/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.jacorb.JacORBExtension;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.ReloadRequiredAddStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;

public class IORASContextDefinition
extends PersistentResourceDefinition {
    static final AttributeDefinition AUTH_METHOD = new SimpleAttributeDefinitionBuilder("auth-method", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(AuthMethodValues.USERNAME_PASSWORD.toString())).setValidator((ParameterValidator)new EnumValidator(AuthMethodValues.class, true, true)).setAllowExpression(true).build();
    static final AttributeDefinition REALM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).setAllowExpression(true).build();
    static final AttributeDefinition REQUIRED = new SimpleAttributeDefinitionBuilder("required", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = Arrays.asList(AUTH_METHOD, REALM, REQUIRED);
    static final IORASContextDefinition INSTANCE = new IORASContextDefinition();

    private IORASContextDefinition() {
        super(PathElement.pathElement((String)"setting", (String)"as-context"), JacORBExtension.getResourceDescriptionResolver("ior-settings", "as-context"), (OperationStepHandler)new ReloadRequiredAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.setDeprecated(JacORBExtension.DEPRECATED_SINCE);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.singletonList(JacORBSubsystemDefinitions.JACORB_SECURITY_DEF);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    protected IORASContextMetaData getIORASContextMetaData(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        IORASContextMetaData metaData = new IORASContextMetaData();
        metaData.setAuthMethod(AUTH_METHOD.resolveModelAttribute(context, model).asString());
        if (model.hasDefined(REALM.getName())) {
            metaData.setRealm(REALM.resolveModelAttribute(context, model).asString());
        }
        metaData.setRequired(REQUIRED.resolveModelAttribute(context, model).asBoolean());
        return metaData;
    }

    private static enum AuthMethodValues {
        NONE("none"),
        USERNAME_PASSWORD("username_password");

        private String name;

        private AuthMethodValues(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

