/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.ClusterConnectionControlHandler;
import org.jboss.as.messaging.ClusterConnectionRemove;
import org.jboss.as.messaging.ClusterConnectionWriteAttributeHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ClusterConnectionDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"cluster-connection");
    public static final String GET_NODES = "get-nodes";
    @Deprecated
    public static final String GET_STATIC_CONNECTORS_AS_JSON = "get-static-connectors-as-json";
    public static final String[] OPERATIONS = new String[]{"get-nodes", "get-static-connectors-as-json"};
    private final boolean registerRuntimeOnly;
    public static final SimpleAttributeDefinition ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"cluster-connection-address", (ModelType)ModelType.STRING).setXmlName("address").setDefaultValue(null).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition ALLOW_DIRECT_CONNECTIONS_ONLY = SimpleAttributeDefinitionBuilder.create((String)"allow-direct-connections-only", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false)).setAllowNull(true).setAllowExpression(true).setAlternatives(new String[]{"discovery-group-name"}).setRestartAllServices().build();
    public static final SimpleAttributeDefinition CHECK_PERIOD = SimpleAttributeDefinitionBuilder.create((String)"check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterFailureCheckPeriod())).setAllowNull(true).setAllowExpression(true).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setRestartAllServices().build();
    public static final SimpleAttributeDefinition CONNECTION_TTL = SimpleAttributeDefinitionBuilder.create((String)"connection-ttl", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterConnectionTtl())).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition CONNECTOR_REF = SimpleAttributeDefinitionBuilder.create((String)"connector-ref", (ModelType)ModelType.STRING).setRestartAllServices().build();
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"static-connectors", (ModelType)ModelType.STRING).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1))).setXmlName("connector-ref")).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.WrappedListAttributeMarshaller(null))).setAlternatives(new String[]{"discovery-group-name"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group-name", (ModelType)ModelType.STRING).setAllowNull(true).setAlternatives(new String[]{ALLOW_DIRECT_CONNECTIONS_ONLY.getName(), CONNECTOR_REFS.getName()}).setAttributeMarshaller(AttributeMarshallers.DISCOVERY_GROUP_MARSHALLER)).setRestartAllServices().build();
    public static final SimpleAttributeDefinition FORWARD_WHEN_NO_CONSUMERS = SimpleAttributeDefinitionBuilder.create((String)"forward-when-no-consumers", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultClusterForwardWhenNoConsumers())).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition MAX_HOPS = SimpleAttributeDefinitionBuilder.create((String)"max-hops", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterMaxHops())).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition MAX_RETRY_INTERVAL = SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterMaxRetryInterval())).setAllowNull(true).setAllowExpression(true).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setRestartAllServices().build();
    public static final SimpleAttributeDefinition NOTIFICATION_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"notification-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterNotificationAttempts())).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition NOTIFICATION_INTERVAL = SimpleAttributeDefinitionBuilder.create((String)"notification-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterNotificationInterval())).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition RETRY_INTERVAL = SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterRetryInterval())).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterReconnectAttempts())).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition RETRY_INTERVAL_MULTIPLIER = SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.BIG_DECIMAL).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterRetryIntervalMultiplier())).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition USE_DUPLICATE_DETECTION = SimpleAttributeDefinitionBuilder.create((String)"use-duplicate-detection", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultClusterDuplicateDetection())).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADDRESS, CONNECTOR_REF, CHECK_PERIOD, CONNECTION_TTL, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CALL_TIMEOUT, CommonAttributes.CALL_FAILOVER_TIMEOUT, RETRY_INTERVAL, RETRY_INTERVAL_MULTIPLIER, MAX_RETRY_INTERVAL, RECONNECT_ATTEMPTS, USE_DUPLICATE_DETECTION, FORWARD_WHEN_NO_CONSUMERS, MAX_HOPS, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE, NOTIFICATION_ATTEMPTS, NOTIFICATION_INTERVAL, CONNECTOR_REFS, ALLOW_DIRECT_CONNECTIONS_ONLY, DISCOVERY_GROUP_NAME};
    public static final AttributeDefinition[] ATTRIBUTES_ADDED_IN_1_2_0 = new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT, NOTIFICATION_ATTEMPTS, NOTIFICATION_INTERVAL};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{ADDRESS, ALLOW_DIRECT_CONNECTIONS_ONLY, CHECK_PERIOD, CONNECTION_TTL, FORWARD_WHEN_NO_CONSUMERS, MAX_HOPS, MAX_RETRY_INTERVAL, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, RETRY_INTERVAL, RETRY_INTERVAL_MULTIPLIER, USE_DUPLICATE_DETECTION, CommonAttributes.CALL_TIMEOUT, RECONNECT_ATTEMPTS, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE};
    public static final SimpleAttributeDefinition NODE_ID = SimpleAttributeDefinitionBuilder.create((String)"node-id", (ModelType)ModelType.STRING).setStorageRuntime().build();
    public static final SimpleAttributeDefinition TOPOLOGY = SimpleAttributeDefinitionBuilder.create((String)"topology", (ModelType)ModelType.STRING).setStorageRuntime().build();
    public static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{TOPOLOGY, NODE_ID};

    public ClusterConnectionDefinition(boolean registerRuntimeOnly) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("cluster-connection"), (OperationStepHandler)ClusterConnectionAdd.INSTANCE, (OperationStepHandler)ClusterConnectionRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)ClusterConnectionWriteAttributeHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            ClusterConnectionControlHandler.INSTANCE.registerAttributes(registry);
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)ClusterConnectionControlHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        if (this.registerRuntimeOnly) {
            ClusterConnectionControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
            EnumSet<OperationEntry.Flag> flags = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
            SimpleOperationDefinition getNodesDef = new SimpleOperationDefinitionBuilder(GET_NODES, this.getResourceDescriptionResolver()).withFlags(flags).setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.STRING).build();
            registry.registerOperationHandler((OperationDefinition)getNodesDef, (OperationStepHandler)ClusterConnectionControlHandler.INSTANCE);
            SimpleOperationDefinition getStaticConnectorsAsJson = new SimpleOperationDefinitionBuilder(GET_STATIC_CONNECTORS_AS_JSON, this.getResourceDescriptionResolver()).withFlags(flags).setReplyType(ModelType.STRING).build();
            registry.registerOperationHandler((OperationDefinition)getStaticConnectorsAsJson, (OperationStepHandler)ClusterConnectionControlHandler.INSTANCE);
        }
        super.registerOperations(registry);
    }
}

