/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSTopicControlHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSTopicControlHandler INSTANCE = new JMSTopicControlHandler();
    private final ParametersValidator listMessagesForSubscriptionValidator = new ParametersValidator();
    private final ParametersValidator countMessagesForSubscriptionValidator = new ParametersValidator();
    private final ParametersValidator dropDurableSubscriptionValidator = new ParametersValidator();
    private final ParametersValidator removeMessagesValidator = new ParametersValidator();

    private JMSTopicControlHandler() {
        this.listMessagesForSubscriptionValidator.registerValidator("queue-name", (ParameterValidator)new StringLengthValidator(1));
        this.countMessagesForSubscriptionValidator.registerValidator(CommonAttributes.CLIENT_ID.getName(), (ParameterValidator)new StringLengthValidator(1));
        this.countMessagesForSubscriptionValidator.registerValidator("subscription-name", (ParameterValidator)new StringLengthValidator(1));
        this.countMessagesForSubscriptionValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, false));
        this.dropDurableSubscriptionValidator.registerValidator(CommonAttributes.CLIENT_ID.getName(), (ParameterValidator)new StringLengthValidator(1));
        this.dropDurableSubscriptionValidator.registerValidator("subscription-name", (ParameterValidator)new StringLengthValidator(1));
        this.removeMessagesValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, false));
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block17: {
            if (HornetQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
            String operationName = operation.require("operation").asString();
            String topicName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
            HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            TopicControl control = (TopicControl)TopicControl.class.cast(hqServer.getManagementService().getResource("jms.topic." + topicName));
            if (control == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerMessages.MESSAGES.managementResourceNotFound(address);
            }
            try {
                if ("list-all-subscriptions".equals(operationName)) {
                    String json = control.listAllSubscriptionsAsJSON();
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block17;
                }
                if ("list-all-subscriptions-as-json".equals(operationName)) {
                    context.getResult().set(control.listAllSubscriptionsAsJSON());
                    break block17;
                }
                if ("list-durable-subscriptions".equals(operationName)) {
                    String json = control.listDurableSubscriptionsAsJSON();
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block17;
                }
                if ("list-durable-subscriptions-as-json".equals(operationName)) {
                    context.getResult().set(control.listDurableSubscriptionsAsJSON());
                    break block17;
                }
                if ("list-non-durable-subscriptions".equals(operationName)) {
                    String json = control.listNonDurableSubscriptionsAsJSON();
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block17;
                }
                if ("list-non-durable-subscriptions-as-json".equals(operationName)) {
                    context.getResult().set(control.listNonDurableSubscriptionsAsJSON());
                    break block17;
                }
                if ("list-messages-for-subscription".equals(operationName)) {
                    this.listMessagesForSubscriptionValidator.validate(operation);
                    String queueName = operation.require("queue-name").asString();
                    String json = control.listMessagesForSubscriptionAsJSON(queueName);
                    context.getResult().set(ModelNode.fromJSONString((String)json));
                    break block17;
                }
                if ("list-messages-for-subscription-as-json".equals(operationName)) {
                    String queueName = operation.require("queue-name").asString();
                    context.getResult().set(control.listMessagesForSubscriptionAsJSON(queueName));
                    break block17;
                }
                if ("count-messages-for-subscription".equals(operationName)) {
                    this.countMessagesForSubscriptionValidator.validate(operation);
                    String clientId = operation.require(CommonAttributes.CLIENT_ID.getName()).asString();
                    String subscriptionName = operation.require("subscription-name").asString();
                    String filter = operation.hasDefined(CommonAttributes.FILTER.getName()) ? operation.get(CommonAttributes.FILTER.getName()).asString() : null;
                    context.getResult().set(control.countMessagesForSubscription(clientId, subscriptionName, filter));
                    break block17;
                }
                if ("drop-durable-subscription".equals(operationName)) {
                    this.dropDurableSubscriptionValidator.validate(operation);
                    String clientId = operation.require(CommonAttributes.CLIENT_ID.getName()).asString();
                    String subscriptionName = operation.require("subscription-name").asString();
                    control.dropDurableSubscription(clientId, subscriptionName);
                    context.getResult();
                    break block17;
                }
                if ("drop-all-subscriptions".equals(operationName)) {
                    control.dropAllSubscriptions();
                    context.getResult();
                    break block17;
                }
                if ("remove-messages".equals(operationName)) {
                    this.removeMessagesValidator.validate(operation);
                    String filter = operation.hasDefined(CommonAttributes.FILTER.getName()) ? operation.get(CommonAttributes.FILTER.getName()).asString() : null;
                    context.getResult().set(control.removeMessages(filter));
                    break block17;
                }
                throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

