/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSTopicReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSTopicReadAttributeHandler INSTANCE = new JMSTopicReadAttributeHandler();
    private ParametersValidator validator = new ParametersValidator();

    private JMSTopicReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (HornetQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
            return;
        }
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        String topicName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        TopicControl control = (TopicControl)TopicControl.class.cast(hqServer.getManagementService().getResource("jms.topic." + topicName));
        if (control == null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            throw ControllerMessages.MESSAGES.managementResourceNotFound(address);
        }
        if (CommonAttributes.MESSAGE_COUNT.getName().equals(attributeName)) {
            try {
                context.getResult().set(control.getMessageCount());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (CommonAttributes.DELIVERING_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getDeliveringCount());
        } else if (CommonAttributes.MESSAGES_ADDED.getName().equals(attributeName)) {
            context.getResult().set(control.getMessagesAdded());
        } else if (JMSTopicDefinition.DURABLE_MESSAGE_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getDurableMessageCount());
        } else if (JMSTopicDefinition.NON_DURABLE_MESSAGE_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getNonDurableMessageCount());
        } else if (JMSTopicDefinition.SUBSCRIPTION_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getSubscriptionCount());
        } else if (JMSTopicDefinition.DURABLE_SUBSCRIPTION_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getDurableSubscriptionCount());
        } else if (JMSTopicDefinition.NON_DURABLE_SUBSCRIPTION_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getNonDurableSubscriptionCount());
        } else if (JMSTopicDefinition.TOPIC_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getAddress());
        } else if (CommonAttributes.TEMPORARY.getName().equals(attributeName)) {
            context.getResult().set(control.isTemporary());
        } else {
            throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
        }
        context.stepCompleted();
    }
}

