/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.staxmapper;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.FixedXMLStreamReader;
import org.jboss.staxmapper.Spliterable;
import org.jboss.staxmapper.Spliterator;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.staxmapper.XMLMapperImpl;

final class XMLExtendedStreamReaderImpl
implements XMLExtendedStreamReader {
    private final XMLMapperImpl xmlMapper;
    private final XMLStreamReader streamReader;
    private final XMLStreamReader fixedStreamReader;
    private final Deque<Context> stack = new ArrayDeque<Context>();
    private boolean trimElementText = true;
    private static final int[] NO_INTS = new int[0];
    private static final long[] NO_LONGS = new long[0];
    private static final String[] NO_STRINGS = new String[0];

    XMLExtendedStreamReaderImpl(XMLMapperImpl xmlMapper, XMLStreamReader streamReader) {
        this.xmlMapper = xmlMapper;
        this.streamReader = streamReader;
        this.fixedStreamReader = new FixedXMLStreamReader(this.streamReader);
        this.stack.push(new Context());
    }

    @Override
    public void setTrimElementText(boolean trim) {
        this.trimElementText = trim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAny(Object value) throws XMLStreamException {
        this.require(1, null, null);
        boolean ok = false;
        try {
            Deque<Context> stack = this.stack;
            stack.push(new Context());
            try {
                this.xmlMapper.processNested(this, value);
            }
            finally {
                stack.pop();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.safeClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAttribute(Object value, int index) throws XMLStreamException {
        this.require(1, null, null);
        boolean ok = false;
        try {
            this.xmlMapper.processAttribute(this.fixedStreamReader, index, value);
        }
        finally {
            if (!ok) {
                this.safeClose();
            }
        }
    }

    @Override
    public void discardRemainder() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            try {
                this.doDiscard();
            }
            finally {
                --context.depth;
            }
        } else {
            try {
                throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
            }
            catch (Throwable throwable) {
                this.safeClose();
                throw throwable;
            }
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.streamReader.getProperty(name);
    }

    @Override
    public int next() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            int next = this.streamReader.next();
            if (next == 2) {
                --context.depth;
            } else if (next == 1) {
                ++context.depth;
            }
            return next;
        }
        try {
            throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
        }
        catch (Throwable throwable) {
            this.safeClose();
            throw throwable;
        }
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.streamReader.require(type, namespaceURI, localName);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String text = this.streamReader.getElementText();
        return this.trimElementText ? text.trim() : text;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            int next = this.streamReader.nextTag();
            if (next == 2) {
                --context.depth;
            } else if (next == 1) {
                ++context.depth;
            }
            return next;
        }
        try {
            throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
        }
        catch (Throwable throwable) {
            this.safeClose();
            throw throwable;
        }
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.stack.getFirst().depth > 0 && this.streamReader.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.streamReader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.streamReader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.streamReader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.streamReader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.streamReader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.streamReader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.streamReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.streamReader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.streamReader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.streamReader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.streamReader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.streamReader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.streamReader.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.streamReader.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.streamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.streamReader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.streamReader.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.streamReader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.streamReader.getEventType();
    }

    @Override
    public String getText() {
        return this.streamReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.streamReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.streamReader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.streamReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.streamReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.streamReader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.streamReader.hasText();
    }

    @Override
    public Location getLocation() {
        return this.streamReader.getLocation();
    }

    @Override
    public QName getName() {
        return this.streamReader.getName();
    }

    @Override
    public String getLocalName() {
        return this.streamReader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.streamReader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.streamReader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.streamReader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.streamReader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.streamReader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.streamReader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.streamReader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.streamReader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.streamReader.getPIData();
    }

    @Override
    public int getIntAttributeValue(int index) throws XMLStreamException {
        try {
            return Integer.parseInt(this.getAttributeValue(index));
        }
        catch (NumberFormatException e) {
            throw XMLExtendedStreamReaderImpl.intParseException(e, this.getLocation());
        }
    }

    @Override
    public int[] getIntListAttributeValue(int index) throws XMLStreamException {
        try {
            return XMLExtendedStreamReaderImpl.toInts(Spliterator.over(this.getAttributeValue(index), ' '), 0);
        }
        catch (NumberFormatException e) {
            throw XMLExtendedStreamReaderImpl.intParseException(e, this.getLocation());
        }
    }

    @Override
    public List<String> getListAttributeValue(int index) throws XMLStreamException {
        return Arrays.asList(XMLExtendedStreamReaderImpl.toStrings(Spliterator.over(this.getAttributeValue(index), ' '), 0));
    }

    @Override
    public long getLongAttributeValue(int index) throws XMLStreamException {
        try {
            return Long.parseLong(this.getAttributeValue(index));
        }
        catch (NumberFormatException e) {
            throw XMLExtendedStreamReaderImpl.intParseException(e, this.getLocation());
        }
    }

    @Override
    public long[] getLongListAttributeValue(int index) throws XMLStreamException {
        try {
            return XMLExtendedStreamReaderImpl.toLongs(Spliterator.over(this.getAttributeValue(index), ' '), 0);
        }
        catch (NumberFormatException e) {
            throw XMLExtendedStreamReaderImpl.intParseException(e, this.getLocation());
        }
    }

    @Override
    public <T> T getAttributeValue(int index, Class<T> kind) throws XMLStreamException {
        if (kind == String.class || kind == Object.class) {
            return kind.cast(this.getAttributeValue(index));
        }
        if (kind == Integer.class || kind == Number.class) {
            return kind.cast(this.getIntAttributeValue(index));
        }
        if (kind == Long.class) {
            return kind.cast(this.getLongAttributeValue(index));
        }
        if (kind.isEnum()) {
            T value = Enum.valueOf(kind, this.getAttributeValue(index));
            return value;
        }
        if (kind == char[].class) {
            return kind.cast(this.getAttributeValue(index).toCharArray());
        }
        throw new XMLStreamException("Unknown value type of '" + kind + "'", this.getLocation());
    }

    @Override
    public <T> List<? extends T> getListAttributeValue(int index, Class<T> kind) throws XMLStreamException {
        if (kind == String.class || kind == Object.class) {
            return this.getListAttributeValue(index);
        }
        if (kind == Integer.class || kind == Number.class) {
            ArrayList<T> list = new ArrayList<T>();
            try {
                for (String s : Spliterable.over(this.getAttributeValue(index), ' ')) {
                    list.add(kind.cast(Integer.valueOf(s)));
                }
                return list;
            }
            catch (NumberFormatException e) {
                throw XMLExtendedStreamReaderImpl.intParseException(e, this.getLocation());
            }
        }
        if (kind == Long.class) {
            ArrayList<T> list = new ArrayList<T>();
            try {
                for (String s : Spliterable.over(this.getAttributeValue(index), ' ')) {
                    list.add(kind.cast(Long.valueOf(s)));
                }
                return list;
            }
            catch (NumberFormatException e) {
                throw XMLExtendedStreamReaderImpl.intParseException(e, this.getLocation());
            }
        }
        if (kind.isEnum()) {
            ArrayList<T> list = new ArrayList<T>();
            for (String s : Spliterable.over(this.getAttributeValue(index), ' ')) {
                list.add(kind.cast(Enum.valueOf(kind.asSubclass(Enum.class), s)));
            }
            return list;
        }
        if (kind == char[].class) {
            ArrayList<T> list = new ArrayList<T>();
            for (String s : Spliterable.over(this.getAttributeValue(index), ' ')) {
                list.add(kind.cast(s.toCharArray()));
            }
            return list;
        }
        throw new XMLStreamException("Unknown value type of '" + kind + "'", this.getLocation());
    }

    @Override
    public String getId() throws XMLStreamException {
        return this.getAttributeValue(null, "id");
    }

    @Override
    public XMLMapper getXMLMapper() {
        return this.xmlMapper;
    }

    private void doDiscard() throws XMLStreamException {
        int i;
        while ((i = this.streamReader.next()) != 2) {
            if (i != 1) continue;
            this.doDiscard();
        }
    }

    private void safeClose() {
        try {
            this.streamReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int[] toInts(Iterator<String> i, int count) {
        if (i.hasNext()) {
            String n = i.next();
            int[] ints = XMLExtendedStreamReaderImpl.toInts(i, count + 1);
            ints[count] = Integer.parseInt(n);
            return ints;
        }
        return count == 0 ? NO_INTS : new int[count];
    }

    private static long[] toLongs(Iterator<String> i, int count) {
        if (i.hasNext()) {
            String n = i.next();
            long[] longs = XMLExtendedStreamReaderImpl.toLongs(i, count + 1);
            longs[count] = Long.parseLong(n);
            return longs;
        }
        return count == 0 ? NO_LONGS : new long[count];
    }

    private static String[] toStrings(Iterator<String> i, int count) {
        if (i.hasNext()) {
            String s = i.next();
            String[] strings = XMLExtendedStreamReaderImpl.toStrings(i, count + 1);
            strings[count] = s;
            return strings;
        }
        return count == 0 ? NO_STRINGS : new String[count];
    }

    private static XMLStreamException readPastEnd(Location location) {
        return new XMLStreamException("Attempt to read past end of element", location);
    }

    private static XMLStreamException intParseException(NumberFormatException e, Location location) {
        return new XMLStreamException("Failed to parse an integer attribute", location, e);
    }

    private static final class Context {
        int depth = 1;

        private Context() {
        }
    }
}

