/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.BaseCertLoginModule;
import org.jboss.security.auth.spi.Util;

public class CertRolesLoginModule
extends BaseCertLoginModule {
    private static final String ROLES_PROPERTIES = "rolesProperties";
    private static final String DEFAULT_ROLES_PROPERTIES = "defaultRolesProperties";
    private static final String ROLE_GROUP_SEPERATOR = "roleGroupSeperator";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"rolesProperties", "defaultRolesProperties", "roleGroupSeperator"};
    private String defaultRolesRsrcName = "defaultRoles.properties";
    private String rolesRsrcName = "roles.properties";
    private Properties roles;
    private char roleGroupSeperator = (char)46;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        PicketBoxLogger.LOGGER.traceBeginInitialize();
        try {
            String option = (String)options.get(ROLES_PROPERTIES);
            if (option != null) {
                this.rolesRsrcName = option;
            }
            if ((option = (String)options.get(DEFAULT_ROLES_PROPERTIES)) != null) {
                this.defaultRolesRsrcName = option;
            }
            if ((option = (String)options.get(ROLE_GROUP_SEPERATOR)) != null) {
                this.roleGroupSeperator = option.charAt(0);
            }
            this.loadRoles();
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.errorLoadingUserRolesPropertiesFiles(e);
        }
        PicketBoxLogger.LOGGER.traceEndInitialize();
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        if (this.roles == null) {
            throw PicketBoxMessages.MESSAGES.missingPropertiesFile(this.rolesRsrcName);
        }
        boolean wasSuccessful = super.login();
        PicketBoxLogger.LOGGER.traceEndLogin(wasSuccessful);
        return wasSuccessful;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        Group[] roleSets = Util.getRoleSets(targetUser, this.roles, this.roleGroupSeperator, this);
        return roleSets;
    }

    private void loadRoles() throws IOException {
        this.roles = Util.loadProperties(this.defaultRolesRsrcName, this.rolesRsrcName);
    }
}

