/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.mapped.BytesUtils;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFile;
import org.apache.activemq.artemis.core.io.mapped.TimedSequentialFile;
import org.apache.activemq.artemis.utils.Env;

public final class MappedSequentialFileFactory
extends AbstractSequentialFileFactory {
    private int capacity;
    private boolean bufferPooling;
    private final ThreadLocal<ByteBuffer> bytesPool;

    public MappedSequentialFileFactory(File directory, int capacity, boolean buffered, int bufferSize, int bufferTimeout, IOCriticalErrorListener criticalErrorListener) {
        super(directory, buffered, bufferSize, bufferTimeout, 1, false, criticalErrorListener, null);
        this.capacity = capacity;
        this.setDatasync(true);
        this.bufferPooling = true;
        this.bytesPool = new ThreadLocal();
    }

    public MappedSequentialFileFactory capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        MappedSequentialFile mappedSequentialFile = new MappedSequentialFile(this, this.journalDir, new File(this.journalDir, fileName), this.capacity, this.critialErrorListener);
        if (this.timedBuffer == null) {
            return mappedSequentialFile;
        }
        return new TimedSequentialFile(this, mappedSequentialFile);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int requiredCapacity = (int)BytesUtils.align(size, Env.osPageSize());
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    public MappedSequentialFileFactory enableBufferReuse() {
        this.bufferPooling = true;
        return this;
    }

    public MappedSequentialFileFactory disableBufferReuse() {
        this.bufferPooling = false;
        return this;
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        if (!this.bufferPooling) {
            return this.allocateDirectBuffer(size);
        }
        int requiredCapacity = (int)BytesUtils.align(size, Env.osPageSize());
        ByteBuffer byteBuffer = this.bytesPool.get();
        if (byteBuffer == null || requiredCapacity > byteBuffer.capacity()) {
            byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        } else {
            this.bytesPool.set(null);
            PlatformDependent.setMemory((long)PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer), (long)size, (byte)0);
            byteBuffer.clear();
        }
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (this.bufferPooling && buffer.isDirect() && (byteBuffer = this.bytesPool.get()) != buffer) {
            if (byteBuffer == null || buffer.capacity() > byteBuffer.capacity()) {
                if (byteBuffer != null) {
                    PlatformDependent.freeDirectBuffer((ByteBuffer)byteBuffer);
                }
                this.bytesPool.set(buffer);
            } else {
                PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
            }
        }
    }

    @Override
    public MappedSequentialFileFactory setDatasync(boolean enabled) {
        super.setDatasync(enabled);
        return this;
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    @Deprecated
    public MappedSequentialFileFactory setAlignment(int alignment) {
        throw new UnsupportedOperationException("alignment can't be changed!");
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            BytesUtils.zerosDirect(buffer);
        } else if (buffer.hasArray()) {
            byte[] array = buffer.array();
            Arrays.fill(array, (byte)0);
        } else {
            int capacity = buffer.capacity();
            for (int i = 0; i < capacity; ++i) {
                buffer.put(i, (byte)0);
            }
        }
        buffer.rewind();
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
    }
}

