/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.controller;

import java.util.EnumSet;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.NoSuchResourceException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CancelActiveOperationHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("cancel", DomainManagementResolver.getResolver("core", "management-operations", "active-operation")).setReplyType(ModelType.BOOLEAN).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    static final OperationStepHandler INSTANCE = new CancelActiveOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DomainManagementLogger.ROOT_LOGGER.debugf("Cancel of %s requested", PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue());
        context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean cancelled = false;
                try {
                    Cancellable cancellable = (Cancellable)Cancellable.class.cast(context.readResource(PathAddress.EMPTY_ADDRESS));
                    DomainManagementLogger.ROOT_LOGGER.debugf("Cancelling %s", cancellable);
                    cancelled = cancellable.cancel();
                }
                catch (NoSuchResourceException nsre) {
                    // empty catch block
                }
                context.getResult().set(cancelled);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

