/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PropertiesFileLoader {
    private static final char[] ESCAPE_ARRAY = new char[]{'=', '\\'};
    protected static final String COMMENT_PREFIX = "#";
    private final String path;
    private final InjectedValue<String> relativeTo = new InjectedValue();
    protected File propertiesFile;
    private volatile long fileUpdated = -1L;
    private volatile Properties properties = null;
    private Properties toSave = null;

    public PropertiesFileLoader(String path) {
        this.path = path;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    public void start(StartContext context) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        this.propertiesFile = new File(file);
        try {
            this.getProperties();
        }
        catch (IOException ioe) {
            throw DomainManagementMessages.MESSAGES.unableToLoadProperties(ioe);
        }
    }

    public void stop(StopContext context) {
        this.properties.clear();
        this.properties = null;
        this.propertiesFile = null;
    }

    public Properties getProperties() throws IOException {
        this.loadAsRequired();
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAsRequired() throws IOException {
        boolean loadRequired;
        boolean bl = loadRequired = this.properties == null || this.fileUpdated != this.propertiesFile.lastModified();
        if (loadRequired) {
            PropertiesFileLoader propertiesFileLoader = this;
            synchronized (propertiesFileLoader) {
                boolean loadReallyRequired;
                long fileLastModified = this.propertiesFile.lastModified();
                boolean bl2 = loadReallyRequired = this.properties == null || this.fileUpdated != fileLastModified;
                if (loadReallyRequired) {
                    this.load();
                    this.fileUpdated = fileLastModified;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws IOException {
        DomainManagementLogger.ROOT_LOGGER.debugf("Reloading properties file '%s'", this.propertiesFile.getAbsolutePath());
        Properties props = new Properties();
        InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(this.propertiesFile), Charset.forName("UTF-8"));
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        this.verifyProperties(props);
        this.properties = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistProperties() throws IOException {
        this.beginPersistence();
        ArrayList<String> content = new ArrayList<String>();
        FileReader fileReader = new FileReader(this.propertiesFile);
        BufferedReader bufferedFileReader = new BufferedReader(fileReader);
        try {
            String line = null;
            boolean i = false;
            while ((line = bufferedFileReader.readLine()) != null) {
                content.add(line);
            }
        }
        finally {
            this.safeClose(bufferedFileReader);
            this.safeClose(fileReader);
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.propertiesFile), "UTF8"));
        try {
            for (String line : content) {
                String userName;
                String trimmed = line.trim();
                if (trimmed.startsWith(COMMENT_PREFIX)) {
                    this.write(bw, line, true);
                    continue;
                }
                if (trimmed.length() == 0) {
                    bw.newLine();
                    continue;
                }
                int equals = trimmed.indexOf(61);
                if (equals <= 0 || !this.toSave.containsKey(userName = trimmed.substring(0, equals))) continue;
                String escapedUserName = PropertiesFileLoader.escapeString(userName, ESCAPE_ARRAY);
                this.write(bw, escapedUserName + "=" + this.toSave.getProperty(userName), true);
                this.toSave.remove(userName);
            }
            this.endPersistence(bw);
        }
        finally {
            this.safeClose(bw);
        }
    }

    protected void beginPersistence() throws IOException {
        this.toSave = (Properties)this.properties.clone();
    }

    protected void write(BufferedWriter writer, String line, boolean newLine) throws IOException {
        writer.append(line);
        if (newLine) {
            writer.newLine();
        }
    }

    protected void endPersistence(BufferedWriter writer) throws IOException {
        for (Object currentKey : this.toSave.keySet()) {
            String escapedUserName = PropertiesFileLoader.escapeString((String)currentKey, ESCAPE_ARRAY);
            this.write(writer, escapedUserName + "=" + this.toSave.getProperty((String)currentKey), true);
        }
        this.toSave = null;
    }

    public static String escapeString(String name, char[] escapeArray) {
        Arrays.sort(escapeArray);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Arrays.binarySearch(escapeArray, ch) < 0) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            builder.append('\\').append(ch);
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (Arrays.binarySearch(escapeArray, ch) >= 0) {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    protected void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void verifyProperties(Properties properties) throws IOException {
    }
}

