/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class LengthRestriction
implements PasswordRestriction {
    private final int desiredLength;

    public LengthRestriction(int desiredLength) {
        this.desiredLength = desiredLength;
    }

    @Override
    public String getRequirementMessage() {
        return DomainManagementMessages.MESSAGES.passwordLengthInfo(this.desiredLength);
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        if (password == null || password.length() < this.desiredLength) {
            throw DomainManagementMessages.MESSAGES.passwordNotLongEnough(this.desiredLength);
        }
    }
}

