/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.auth;

import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.jacc.PolicyContext;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.plugins.auth.JaasSecurityManagerBase;

public class JASPIServerAuthenticationManager
extends JaasSecurityManagerBase
implements ServerAuthenticationManager {
    public JASPIServerAuthenticationManager() {
    }

    public JASPIServerAuthenticationManager(String securityDomain, CallbackHandler handler) {
        super(securityDomain, handler);
    }

    @Override
    public boolean isValid(MessageInfo requestMessage, Subject clientSubject, String layer, CallbackHandler handler) {
        return this.isValid(requestMessage, clientSubject, layer, PolicyContext.getContextID(), handler);
    }

    @Override
    public boolean isValid(MessageInfo messageInfo, Subject clientSubject, String layer, String appContext, CallbackHandler callbackHandler) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
        if (provider == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
        }
        ServerAuthConfig serverConfig = null;
        try {
            serverConfig = provider.getServerAuthConfig(layer, appContext, callbackHandler);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), (Object)ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthConfig(layer, appContext, ae);
            return false;
        }
        String authContextId = serverConfig.getAuthContextID(messageInfo);
        Properties properties = new Properties();
        properties.setProperty("security-domain", super.getSecurityDomain());
        ServerAuthContext sctx = null;
        try {
            sctx = serverConfig.getAuthContext(authContextId, new Subject(), (Map)properties);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), (Object)ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthContext(authContextId, super.getSecurityDomain(), ae);
            return false;
        }
        if (clientSubject == null) {
            clientSubject = new Subject();
        }
        Subject serviceSubject = new Subject();
        AuthStatus status = AuthStatus.FAILURE;
        try {
            status = sctx.validateRequest(messageInfo, clientSubject, serviceSubject);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), (Object)ae);
            PicketBoxLogger.LOGGER.debugIgnoredException(ae);
        }
        return AuthStatus.SUCCESS == status;
    }

    @Override
    public void secureResponse(MessageInfo messageInfo, Subject serviceSubject, String layer, String appContext, CallbackHandler handler) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
        if (provider == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
        }
        ServerAuthConfig serverConfig = null;
        try {
            serverConfig = provider.getServerAuthConfig(layer, appContext, handler);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), (Object)ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthConfig(layer, appContext, ae);
            return;
        }
        String authContextId = serverConfig.getAuthContextID(messageInfo);
        Properties properties = new Properties();
        properties.setProperty("security-domain", super.getSecurityDomain());
        if (serviceSubject == null) {
            serviceSubject = new Subject();
        }
        ServerAuthContext sctx = null;
        try {
            sctx = serverConfig.getAuthContext(authContextId, serviceSubject, (Map)properties);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), (Object)ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthContext(authContextId, super.getSecurityDomain(), ae);
            return;
        }
        try {
            sctx.secureResponse(messageInfo, serviceSubject);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), (Object)ae);
            PicketBoxLogger.LOGGER.debugIgnoredException(ae);
        }
    }
}

