/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import jakarta.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public final class AddressSettingsInfo {
    private final String addressFullMessagePolicy;
    private final long maxSizeBytes;
    private final int pageSizeBytes;
    private int pageCacheMaxSize;
    private final int maxDeliveryAttempts;
    private final double redeliveryMultiplier;
    private final long maxRedeliveryDelay;
    private final long redeliveryDelay;
    private final String deadLetterAddress;
    private final String expiryAddress;
    private final boolean lastValueQueue;
    private final long redistributionDelay;
    private final boolean sendToDLAOnNoRoute;
    private final long slowConsumerThreshold;
    private final long slowConsumerCheckPeriod;
    private final String slowConsumerPolicy;
    private final boolean autoCreateJmsQueues;
    private final boolean autoDeleteJmsQueues;
    private final boolean autoCreateJmsTopics;
    private final boolean autoDeleteJmsTopics;

    public static AddressSettingsInfo from(String jsonString) {
        JsonObject object = JsonUtil.readJsonObject(jsonString);
        return new AddressSettingsInfo(object.getString("addressFullMessagePolicy"), object.getJsonNumber("maxSizeBytes").longValue(), object.getInt("pageSizeBytes"), object.getInt("pageCacheMaxSize"), object.getInt("maxDeliveryAttempts"), object.getJsonNumber("redeliveryDelay").longValue(), object.getJsonNumber("redeliveryMultiplier").doubleValue(), object.getJsonNumber("maxRedeliveryDelay").longValue(), object.getString("DLA"), object.getString("expiryAddress"), object.getBoolean("lastValueQueue"), object.getJsonNumber("redistributionDelay").longValue(), object.getBoolean("sendToDLAOnNoRoute"), object.getJsonNumber("slowConsumerThreshold").longValue(), object.getJsonNumber("slowConsumerCheckPeriod").longValue(), object.getString("slowConsumerPolicy"), object.getBoolean("autoCreateJmsQueues"), object.getBoolean("autoCreateJmsTopics"), object.getBoolean("autoDeleteJmsQueues"), object.getBoolean("autoDeleteJmsTopics"));
    }

    public AddressSettingsInfo(String addressFullMessagePolicy, long maxSizeBytes, int pageSizeBytes, int pageCacheMaxSize, int maxDeliveryAttempts, long redeliveryDelay, double redeliveryMultiplier, long maxRedeliveryDelay, String deadLetterAddress, String expiryAddress, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, long slowConsumerThreshold, long slowConsumerCheckPeriod, String slowConsumerPolicy, boolean autoCreateJmsQueues, boolean autoCreateJmsTopics, boolean autoDeleteJmsQueues, boolean autoDeleteJmsTopics) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        this.maxSizeBytes = maxSizeBytes;
        this.pageSizeBytes = pageSizeBytes;
        this.pageCacheMaxSize = pageCacheMaxSize;
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        this.redeliveryDelay = redeliveryDelay;
        this.redeliveryMultiplier = redeliveryMultiplier;
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        this.deadLetterAddress = deadLetterAddress;
        this.expiryAddress = expiryAddress;
        this.lastValueQueue = lastValueQueue;
        this.redistributionDelay = redistributionDelay;
        this.sendToDLAOnNoRoute = sendToDLAOnNoRoute;
        this.slowConsumerThreshold = slowConsumerThreshold;
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        this.slowConsumerPolicy = slowConsumerPolicy;
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        this.autoCreateJmsTopics = autoCreateJmsTopics;
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
    }

    public int getPageCacheMaxSize() {
        return this.pageCacheMaxSize;
    }

    public void setPageCacheMaxSize(int pageCacheMaxSize) {
        this.pageCacheMaxSize = pageCacheMaxSize;
    }

    public String getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public String getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public String getExpiryAddress() {
        return this.expiryAddress;
    }

    public boolean isLastValueQueue() {
        return this.lastValueQueue;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute;
    }

    public double getRedeliveryMultiplier() {
        return this.redeliveryMultiplier;
    }

    public long getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay;
    }

    public long getSlowConsumerThreshold() {
        return this.slowConsumerThreshold;
    }

    public long getSlowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod;
    }

    public String getSlowConsumerPolicy() {
        return this.slowConsumerPolicy;
    }

    public boolean isAutoCreateJmsQueues() {
        return this.autoCreateJmsQueues;
    }

    public boolean isAutoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues;
    }

    public boolean isAutoCreateJmsTopics() {
        return this.autoCreateJmsTopics;
    }

    public boolean isAutoDeleteJmsTopics() {
        return this.autoDeleteJmsTopics;
    }
}

