/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import jakarta.ejb.EJBException;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBHandle;
import org.jboss.ejb.client.EJBHomeHandle;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.SerializedEJBInvocationHandler;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.wildfly.common.Assert;
import org.wildfly.discovery.Discovery;
import org.wildfly.security.auth.client.AuthenticationContext;

final class EJBInvocationHandler<T>
extends Attachable
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 946555285095057230L;
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(Discovery.getContextManager()::getPrivilegedSupplier);
    private static final int MAX_RETRIES = AccessController.doPrivileged(() -> {
        String val = System.getProperty("org.jboss.ejb.client.max-retries");
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            return 8;
        }
    });
    private final transient boolean async;
    private transient String toString;
    private transient String toStringProxy;
    private final AtomicReference<EJBLocator<T>> locatorRef;
    private volatile Affinity weakAffinity = Affinity.NONE;
    private volatile long invocationTimeout = -1L;
    private volatile Supplier<AuthenticationContext> authenticationContextSupplier;

    EJBInvocationHandler(EJBLocator<T> locator, Supplier<AuthenticationContext> authenticationContextSupplier) {
        Assert.checkNotNullParam("locator", locator);
        this.authenticationContextSupplier = authenticationContextSupplier;
        this.locatorRef = new AtomicReference<EJBLocator<T>>(locator);
        this.async = false;
        if (locator instanceof StatefulEJBLocator) {
            this.setWeakAffinity(locator.getAffinity());
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("EJBInvocationHandler: setting weak affinity = %s", (Object)locator.getAffinity());
            }
        }
    }

    EJBInvocationHandler(EJBInvocationHandler<T> other) {
        super(other);
        EJBLocator<T> locator = other.locatorRef.get();
        this.locatorRef = new AtomicReference<EJBLocator<T>>(locator);
        this.authenticationContextSupplier = other.authenticationContextSupplier;
        this.async = true;
        if (locator instanceof StatefulEJBLocator) {
            this.setWeakAffinity(locator.getAffinity());
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("EJBInvocationHandler(constructor): setting weak affinity = %s", (Object)locator.getAffinity());
            }
        }
    }

    @Override
    public Object invoke(Object rawProxy, Method method, Object ... args) throws Exception {
        T proxy = this.locatorRef.get().getViewType().cast(rawProxy);
        EJBProxyInformation.ProxyMethodInfo methodInfo = this.locatorRef.get().getProxyInformation().getProxyMethodInfo(method);
        return this.invoke(proxy, methodInfo, args);
    }

    EJBProxyInformation.ProxyMethodInfo getProxyMethodInfo(EJBMethodLocator methodLocator) {
        return this.locatorRef.get().getProxyInformation().getProxyMethodInfo(methodLocator);
    }

    Object invoke(Object proxy, EJBProxyInformation.ProxyMethodInfo methodInfo, Object ... args) throws Exception {
        Method method = methodInfo.getMethod();
        switch (methodInfo.getMethodType()) {
            case 1: 
            case 6: {
                InvocationHandler handler;
                assert (args.length == 1);
                if (args[0] instanceof Proxy && (handler = Proxy.getInvocationHandler(args[0])) instanceof EJBInvocationHandler) {
                    return this.equals(handler);
                }
                return Boolean.FALSE;
            }
            case 2: {
                return this.locatorRef.get().hashCode();
            }
            case 3: {
                String s = this.toStringProxy;
                return s != null ? s : (this.toStringProxy = String.format("Proxy for remote EJB %s", this.locatorRef.get()));
            }
            case 4: {
                if (this.locatorRef.get().isEntity()) {
                    return this.locatorRef.get().narrowAsEntity(EJBObject.class).getPrimaryKey();
                }
                throw new RemoteException("Cannot invoke getPrimaryKey() on " + proxy);
            }
            case 5: {
                return EJBHandle.create(this.locatorRef.get().narrowTo(EJBObject.class));
            }
            case 7: {
                if (this.locatorRef.get() instanceof EJBHomeLocator) {
                    return EJBHomeHandle.create(this.locatorRef.get().narrowAsHome(EJBHome.class));
                }
                throw new RemoteException("Cannot invoke getHomeHandle() on " + proxy);
            }
        }
        assert (methodInfo.getMethodType() == 0);
        EJBClientContext clientContext = EJBClientContext.getCurrent();
        Discovery discoveryContext = DISCOVERY_SUPPLIER.get();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("Calling invoke(module = %s, strong affinity = %s, weak affinity = %s): ", (Object)this.locatorRef.get().getIdentifier(), (Object)this.locatorRef.get().getAffinity(), (Object)this.weakAffinity);
        }
        EJBClientInvocationContext invocationContext = new EJBClientInvocationContext(this, clientContext, proxy, args, methodInfo, MAX_RETRIES, this.authenticationContextSupplier, discoveryContext);
        invocationContext.setLocator(this.locatorRef.get());
        invocationContext.setBlockingCaller(true);
        invocationContext.setWeakAffinity(this.getWeakAffinity());
        try {
            invocationContext.sendRequestInitial();
            if (!this.async && !methodInfo.isClientAsync()) {
                return invocationContext.awaitResponse();
            }
            invocationContext.setBlockingCaller(false);
            if (method.getReturnType() == Future.class) {
                return invocationContext.getFutureResponse();
            }
            if (method.getReturnType() == Void.TYPE) {
                invocationContext.setDiscardResult();
                return null;
            }
            EJBClient.setFutureResult(invocationContext.getFutureResponse());
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            boolean remoteException = false;
            for (Class<?> exception : method.getExceptionTypes()) {
                if (exception.isAssignableFrom(e.getClass())) {
                    throw e;
                }
                if (!RemoteException.class.equals(exception)) continue;
                remoteException = true;
            }
            if (remoteException) {
                throw new RemoteException("Error", e);
            }
            throw new EJBException(e);
        }
    }

    void setWeakAffinity(Affinity newWeakAffinity) {
        this.weakAffinity = newWeakAffinity;
    }

    Affinity getWeakAffinity() {
        return this.weakAffinity;
    }

    static <T> EJBInvocationHandler<? extends T> forProxy(T proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof EJBInvocationHandler) {
            return (EJBInvocationHandler)handler;
        }
        throw Logs.MAIN.proxyNotOurs(proxy, EJBClient.class.getName());
    }

    protected Object writeReplace() {
        return new SerializedEJBInvocationHandler(this.locatorRef.get(), this.async);
    }

    EJBInvocationHandler<T> getAsyncHandler() {
        return this.async ? this : new EJBInvocationHandler<T>(this);
    }

    boolean isAsyncHandler() {
        return this.async;
    }

    EJBLocator<T> getLocator() {
        return this.locatorRef.get();
    }

    public boolean equals(Object other) {
        return other instanceof EJBInvocationHandler && this.equals((EJBInvocationHandler)other);
    }

    public boolean equals(InvocationHandler other) {
        return other instanceof EJBInvocationHandler && this.equals((EJBInvocationHandler)other);
    }

    public boolean equals(EJBInvocationHandler<?> other) {
        return this == other || other != null && this.locatorRef.get().equals(other.locatorRef.get()) && this.async == other.async;
    }

    public int hashCode() {
        int hc = this.locatorRef.get().hashCode();
        if (this.async) {
            ++hc;
        }
        return hc;
    }

    public String toString() {
        String s = this.toString;
        return s != null ? s : (this.toString = String.format("Proxy invocation handler for %s", this.locatorRef.get()));
    }

    void setStrongAffinity(Affinity newAffinity) {
        EJBLocator<T> newVal;
        EJBLocator<T> oldVal;
        AtomicReference<EJBLocator<T>> locatorRef = this.locatorRef;
        do {
            if (!(oldVal = locatorRef.get()).getAffinity().equals(newAffinity)) continue;
            return;
        } while (!locatorRef.compareAndSet(oldVal, newVal = oldVal.withNewAffinity(newAffinity)));
    }

    void setSessionID(SessionID sessionID) {
        StatefulEJBLocator<T> newVal;
        EJBLocator<T> oldVal;
        AtomicReference<EJBLocator<T>> locatorRef = this.locatorRef;
        do {
            if (!(oldVal = locatorRef.get()).isStateful()) continue;
            if (oldVal.asStateful().getSessionId().equals((Object)sessionID)) {
                return;
            }
            throw Logs.MAIN.ejbIsAlreadyStateful();
        } while (!locatorRef.compareAndSet(oldVal, newVal = oldVal.withSession(sessionID)));
    }

    long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    void setInvocationTimeout(long invocationTimeout) {
        this.invocationTimeout = invocationTimeout;
    }

    boolean compareAndSetStrongAffinity(Affinity expectedAffinity, Affinity newAffinity) {
        Assert.checkNotNullParam("expectedAffinity", expectedAffinity);
        Assert.checkNotNullParam("newAffinity", newAffinity);
        AtomicReference<EJBLocator<T>> locatorRef = this.locatorRef;
        EJBLocator<T> oldVal = locatorRef.get();
        if (!oldVal.getAffinity().equals(expectedAffinity)) {
            return false;
        }
        EJBLocator<T> newVal = oldVal.withNewAffinity(newAffinity);
        return locatorRef.compareAndSet(oldVal, newVal);
    }
}

