/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.utils.BufferHelper;

public class SessionQueueQueryResponseMessage_V3
extends SessionQueueQueryResponseMessage_V2 {
    protected boolean autoCreated;
    protected boolean purgeOnNoConsumers;
    protected RoutingType routingType;
    protected int maxConsumers;
    protected Boolean exclusive;
    protected Boolean groupRebalance;
    protected Boolean groupRebalancePauseDispatch;
    protected Integer groupBuckets;
    protected SimpleString groupFirstKey;
    protected Boolean lastValue;
    protected SimpleString lastValueKey;
    protected Boolean nonDestructive;
    private Integer consumersBeforeDispatch;
    private Long delayBeforeDispatch;
    private Boolean autoDelete;
    private Long autoDeleteDelay;
    private Long autoDeleteMessageCount;
    protected Integer defaultConsumerWindowSize;
    private Long ringSize;
    private Boolean enabled;

    public SessionQueueQueryResponseMessage_V3(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists(), result.isAutoCreateQueues(), result.isAutoCreated(), result.isPurgeOnNoConsumers(), result.getRoutingType(), result.getMaxConsumers(), result.isExclusive(), result.isGroupRebalance(), result.isGroupRebalancePauseDispatch(), result.getGroupBuckets(), result.getGroupFirstKey(), result.isLastValue(), result.getLastValueKey(), result.isNonDestructive(), result.getConsumersBeforeDispatch(), result.getDelayBeforeDispatch(), result.isAutoDelete(), result.getAutoDeleteDelay(), result.getAutoDeleteMessageCount(), result.getDefaultConsumerWindowSize(), result.getRingSize(), result.isEnabled());
    }

    public SessionQueueQueryResponseMessage_V3() {
        this(null, null, false, false, null, 0, 0L, false, false, false, false, RoutingType.MULTICAST, -1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private SessionQueueQueryResponseMessage_V3(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists, boolean autoCreateQueues, boolean autoCreated, boolean purgeOnNoConsumers, RoutingType routingType, int maxConsumers, Boolean exclusive, Boolean groupRebalance, Boolean groupRebalancePauseDispatch, Integer groupBuckets, SimpleString groupFirstKey, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, Integer defaultConsumerWindowSize, Long ringSize, Boolean enabled) {
        super((byte)-14);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreated = autoCreated;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
        this.exclusive = exclusive;
        this.groupRebalance = groupRebalance;
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
        this.groupBuckets = groupBuckets;
        this.groupFirstKey = groupFirstKey;
        this.lastValue = lastValue;
        this.lastValueKey = lastValueKey;
        this.nonDestructive = nonDestructive;
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        this.delayBeforeDispatch = delayBeforeDispatch;
        this.autoDelete = autoDelete;
        this.autoDeleteDelay = autoDeleteDelay;
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        this.ringSize = ringSize;
        this.enabled = enabled;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
    }

    public SimpleString getLastValueKey() {
        return this.lastValueKey;
    }

    public void setLastValueKey(SimpleString lastValueKey) {
        this.lastValueKey = lastValueKey;
    }

    public Boolean isNonDestructive() {
        return this.nonDestructive;
    }

    public void setNonDestructive(Boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
    }

    public Integer getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    public void setConsumersBeforeDispatch(Integer consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
    }

    public Long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    public void setDelayBeforeDispatch(Long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
    }

    public Integer getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize;
    }

    public void setDefaultConsumerWindowSize(Integer defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
    }

    public Boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    public void setGroupRebalance(Boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
    }

    public Boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    public void setGroupRebalancePauseDispatch(Boolean groupRebalancePauseDispatch) {
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
    }

    public Integer getGroupBuckets() {
        return this.groupBuckets;
    }

    public void setGroupBuckets(Integer groupBuckets) {
        this.groupBuckets = groupBuckets;
    }

    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    public void setGroupFirstKey(SimpleString groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
    }

    public Boolean isAutoDelete() {
        return this.autoDelete;
    }

    public Long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public Long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public Long getRingSize() {
        return this.ringSize;
    }

    public void setRingSize(Long ringSize) {
        this.ringSize = ringSize;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.autoCreated);
        buffer.writeBoolean(this.purgeOnNoConsumers);
        buffer.writeByte(this.routingType.getType());
        buffer.writeInt(this.maxConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.exclusive);
        BufferHelper.writeNullableBoolean(buffer, this.lastValue);
        BufferHelper.writeNullableInteger(buffer, this.defaultConsumerWindowSize);
        buffer.writeNullableSimpleString(this.lastValueKey);
        BufferHelper.writeNullableBoolean(buffer, this.nonDestructive);
        BufferHelper.writeNullableInteger(buffer, this.consumersBeforeDispatch);
        BufferHelper.writeNullableLong(buffer, this.delayBeforeDispatch);
        BufferHelper.writeNullableBoolean(buffer, this.groupRebalance);
        BufferHelper.writeNullableInteger(buffer, this.groupBuckets);
        BufferHelper.writeNullableBoolean(buffer, this.autoDelete);
        BufferHelper.writeNullableLong(buffer, this.autoDeleteDelay);
        BufferHelper.writeNullableLong(buffer, this.autoDeleteMessageCount);
        buffer.writeNullableSimpleString(this.groupFirstKey);
        BufferHelper.writeNullableLong(buffer, this.ringSize);
        BufferHelper.writeNullableBoolean(buffer, this.enabled);
        BufferHelper.writeNullableBoolean(buffer, this.groupRebalancePauseDispatch);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.autoCreated = buffer.readBoolean();
        this.purgeOnNoConsumers = buffer.readBoolean();
        this.routingType = RoutingType.getType(buffer.readByte());
        this.maxConsumers = buffer.readInt();
        if (buffer.readableBytes() > 0) {
            this.exclusive = BufferHelper.readNullableBoolean(buffer);
            this.lastValue = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumerWindowSize = BufferHelper.readNullableInteger(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.lastValueKey = buffer.readNullableSimpleString();
            this.nonDestructive = BufferHelper.readNullableBoolean(buffer);
            this.consumersBeforeDispatch = BufferHelper.readNullableInteger(buffer);
            this.delayBeforeDispatch = BufferHelper.readNullableLong(buffer);
            this.groupRebalance = BufferHelper.readNullableBoolean(buffer);
            this.groupBuckets = BufferHelper.readNullableInteger(buffer);
            this.autoDelete = BufferHelper.readNullableBoolean(buffer);
            this.autoDeleteDelay = BufferHelper.readNullableLong(buffer);
            this.autoDeleteMessageCount = BufferHelper.readNullableLong(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.groupFirstKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.ringSize = BufferHelper.readNullableLong(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.enabled = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.groupRebalancePauseDispatch = BufferHelper.readNullableBoolean(buffer);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoCreated ? 1231 : 1237);
        result = 31 * result + (this.purgeOnNoConsumers ? 1231 : 1237);
        result = 31 * result + this.routingType.hashCode();
        result = 31 * result + this.maxConsumers;
        result = 31 * result + (this.exclusive == null ? 0 : (this.exclusive != false ? 1231 : 1237));
        result = 31 * result + (this.groupRebalance == null ? 0 : (this.groupRebalance != false ? 1231 : 1237));
        result = 31 * result + (this.groupRebalancePauseDispatch == null ? 0 : (this.groupRebalancePauseDispatch != false ? 1231 : 1237));
        result = 31 * result + (this.groupBuckets == null ? 0 : this.groupBuckets.hashCode());
        result = 31 * result + (this.groupFirstKey == null ? 0 : this.groupFirstKey.hashCode());
        result = 31 * result + (this.lastValue == null ? 0 : (this.lastValue != false ? 1231 : 1237));
        result = 31 * result + (this.lastValueKey == null ? 0 : this.lastValueKey.hashCode());
        result = 31 * result + (this.nonDestructive == null ? 0 : (this.nonDestructive != false ? 1231 : 1237));
        result = 31 * result + (this.consumersBeforeDispatch == null ? 0 : this.consumersBeforeDispatch.hashCode());
        result = 31 * result + (this.delayBeforeDispatch == null ? 0 : this.delayBeforeDispatch.hashCode());
        result = 31 * result + (this.autoDelete == null ? 0 : this.autoDelete.hashCode());
        result = 31 * result + (this.autoDeleteDelay == null ? 0 : this.autoDeleteDelay.hashCode());
        result = 31 * result + (this.autoDeleteMessageCount == null ? 0 : this.autoDeleteMessageCount.hashCode());
        result = 31 * result + (this.defaultConsumerWindowSize == null ? 0 : this.defaultConsumerWindowSize.hashCode());
        result = 31 * result + (this.ringSize == null ? 0 : this.ringSize.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : (this.enabled != false ? 1231 : 1237));
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append("]");
        return buff.toString();
    }

    @Override
    public String getParentString() {
        StringBuffer buff = new StringBuffer(super.getParentString());
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        buff.append(", routingType=" + (Object)((Object)this.routingType));
        buff.append(", maxConsumers=" + this.maxConsumers);
        buff.append(", exclusive=" + this.exclusive);
        buff.append(", groupRebalance=" + this.groupRebalance);
        buff.append(", groupRebalancePauseDispatch=" + this.groupRebalancePauseDispatch);
        buff.append(", groupBuckets=" + this.groupBuckets);
        buff.append(", groupFirstKey=" + this.groupFirstKey);
        buff.append(", lastValue=" + this.lastValue);
        buff.append(", lastValueKey=" + this.lastValueKey);
        buff.append(", nonDestructive=" + this.nonDestructive);
        buff.append(", consumersBeforeDispatch=" + this.consumersBeforeDispatch);
        buff.append(", delayBeforeDispatch=" + this.delayBeforeDispatch);
        buff.append(", autoDelete=" + this.autoDelete);
        buff.append(", autoDeleteDelay=" + this.autoDeleteDelay);
        buff.append(", autoDeleteMessageCount=" + this.autoDeleteMessageCount);
        buff.append(", defaultConsumerWindowSize=" + this.defaultConsumerWindowSize);
        buff.append(", ringSize=" + this.ringSize);
        buff.append(", enabled=" + this.enabled);
        return buff.toString();
    }

    @Override
    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists(), this.isAutoCreateQueues(), this.getMaxConsumers(), this.isAutoCreated(), this.isPurgeOnNoConsumers(), this.getRoutingType(), this.isExclusive(), this.isGroupRebalance(), this.isGroupRebalancePauseDispatch(), this.getGroupBuckets(), this.getGroupFirstKey(), this.isLastValue(), this.getLastValueKey(), this.isNonDestructive(), this.getConsumersBeforeDispatch(), this.getDelayBeforeDispatch(), this.isAutoDelete(), this.getAutoDeleteDelay(), this.getAutoDeleteMessageCount(), this.getDefaultConsumerWindowSize(), this.getRingSize(), this.isEnabled());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage_V3)) {
            return false;
        }
        SessionQueueQueryResponseMessage_V3 other = (SessionQueueQueryResponseMessage_V3)obj;
        if (this.autoCreated != other.autoCreated) {
            return false;
        }
        if (this.purgeOnNoConsumers != other.purgeOnNoConsumers) {
            return false;
        }
        if (this.exclusive == null ? other.exclusive != null : !this.exclusive.equals(other.exclusive)) {
            return false;
        }
        if (this.groupRebalance == null ? other.groupRebalance != null : !this.groupRebalance.equals(other.groupRebalance)) {
            return false;
        }
        if (this.groupRebalancePauseDispatch == null ? other.groupRebalancePauseDispatch != null : !this.groupRebalancePauseDispatch.equals(other.groupRebalancePauseDispatch)) {
            return false;
        }
        if (this.groupBuckets == null ? other.groupBuckets != null : !this.groupBuckets.equals(other.groupBuckets)) {
            return false;
        }
        if (this.groupFirstKey == null ? other.groupFirstKey != null : !this.groupFirstKey.equals(other.groupFirstKey)) {
            return false;
        }
        if (this.lastValue == null ? other.lastValue != null : !this.lastValue.equals(other.lastValue)) {
            return false;
        }
        if (this.lastValueKey == null ? other.lastValueKey != null : !this.lastValueKey.equals(other.lastValueKey)) {
            return false;
        }
        if (this.nonDestructive == null ? other.nonDestructive != null : !this.nonDestructive.equals(other.nonDestructive)) {
            return false;
        }
        if (this.consumersBeforeDispatch == null ? other.consumersBeforeDispatch != null : !this.consumersBeforeDispatch.equals(other.consumersBeforeDispatch)) {
            return false;
        }
        if (this.delayBeforeDispatch == null ? other.delayBeforeDispatch != null : !this.delayBeforeDispatch.equals(other.delayBeforeDispatch)) {
            return false;
        }
        if (this.autoDelete == null ? other.autoDelete != null : !this.autoDelete.equals(other.autoDelete)) {
            return false;
        }
        if (this.autoDeleteDelay == null ? other.autoDeleteDelay != null : !this.autoDeleteDelay.equals(other.autoDeleteDelay)) {
            return false;
        }
        if (this.autoDeleteMessageCount == null ? other.autoDeleteMessageCount != null : !this.autoDeleteMessageCount.equals(other.autoDeleteMessageCount)) {
            return false;
        }
        if (this.ringSize == null ? other.ringSize != null : !this.ringSize.equals(other.ringSize)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.defaultConsumerWindowSize == null ? other.defaultConsumerWindowSize != null : !this.defaultConsumerWindowSize.equals(other.defaultConsumerWindowSize)) {
            return false;
        }
        if (this.routingType == null ? other.routingType != null : !this.routingType.equals((Object)other.routingType)) {
            return false;
        }
        return this.maxConsumers == other.maxConsumers;
    }
}

