/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.auth.util;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.sasl.auth.util.AuthenticationContextSaslServer;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class AuthenticationContextSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final AuthenticationContext context;

    public AuthenticationContextSaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
        this.context = AuthenticationContext.captureCurrent();
    }

    public AuthenticationContextSaslServerFactory(SaslServerFactory delegate, AuthenticationContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslServer delegate = super.createSaslServer(mechanism, protocol, serverName, props, cbh);
        if (delegate == null) {
            return null;
        }
        return new AuthenticationContextSaslServer(delegate, this.context);
    }
}

