/*
 * Decompiled with CFR 0.152.
 */
package jakarta.resource;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class ResourceException
extends Exception {
    private static final long serialVersionUID;
    private String errorCode;
    private Exception linkedException;

    public ResourceException() {
    }

    public ResourceException(String message) {
        super(message);
    }

    public ResourceException(Throwable cause) {
        super(cause);
    }

    public ResourceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ResourceException(String message, String errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Exception getLinkedException() {
        return this.linkedException;
    }

    public void setLinkedException(Exception ex) {
        this.linkedException = ex;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        String ec = this.getErrorCode();
        if (msg == null && ec == null) {
            return null;
        }
        if (msg != null && ec != null) {
            return msg + ", error code: " + ec;
        }
        return msg != null ? msg : "error code: " + ec;
    }

    static {
        Boolean legacy = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Boolean run() {
                try {
                    if (System.getProperty("org.jboss.j2ee.LegacySerialization") != null) {
                        return Boolean.TRUE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return Boolean.FALSE;
            }
        });
        serialVersionUID = Boolean.TRUE.equals(legacy) ? 4770679801401540475L : 547071213627824490L;
    }
}

