/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ManagementInterfaces;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.AbstractEnableSSLCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.OptionActivators;

@CommandDefinition(name="enable-ssl-management", description="", activator=SecurityCommandActivator.class)
public class ManagementEnableSSLCommand
extends AbstractEnableSSLCommand {
    private static final String DEFAULT_KEY_STORE_FILE_NAME = "management.keystore";
    private static final String DEFAULT_TRUST_STORE_FILE_NAME = "management.truststore";
    @Option(name="management-interface", completer=SecurityCommand.OptionCompleters.ManagementInterfaceCompleter.class, activator=OptionActivators.ManagementInterfaceActivator.class)
    String managementInterface;
    @Option(name="http-secure-socket-binding", activator=OptionActivators.SecureSocketBindingActivator.class, completer=SecurityCommand.OptionCompleters.SecureSocketBindingCompleter.class)
    String secureSocketBinding;

    public ManagementEnableSSLCommand(CommandContext ctx) {
        super(ctx);
    }

    @Override
    protected void secure(CommandContext ctx, SSLSecurityBuilder builder) throws CommandException {
        try {
            ManagementInterfaces.enableSSL(this.managementInterface, this.secureSocketBinding, ctx, builder);
        }
        catch (Exception ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    String getDefaultKeyStoreFileName(CommandContext ctx) {
        return DEFAULT_KEY_STORE_FILE_NAME;
    }

    @Override
    String getDefaultTrustStoreFileName(CommandContext ctx) {
        return DEFAULT_TRUST_STORE_FILE_NAME;
    }

    @Override
    protected boolean isSSLEnabled(CommandContext ctx) throws Exception {
        String target = this.managementInterface;
        if (target == null) {
            target = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        return ManagementInterfaces.getManagementInterfaceSSLContextName(ctx, target) != null;
    }

    @Override
    protected String getTarget(CommandContext ctx) {
        String target = this.managementInterface;
        if (target == null) {
            target = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        return target;
    }
}

