/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.RawPassword;

class RawClearPassword
extends RawPassword
implements ClearPassword {
    private static final long serialVersionUID = -7982031201140935435L;
    private final char[] password;

    RawClearPassword(String algorithm, char[] password) {
        super(algorithm);
        this.password = password;
    }

    @Override
    public char[] getPassword() throws IllegalStateException {
        return (char[])this.password.clone();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.password == null || this.password.length == 0 || this.password[0] == '\u0000';
    }

    @Override
    public RawClearPassword clone() {
        char[] password = this.password;
        if (password == null || password.length == 0) {
            return this;
        }
        return new RawClearPassword(this.getAlgorithm(), (char[])password.clone());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.password);
    }

    @Override
    public boolean equals(Object obj) {
        char[] password = this.password;
        if (!(obj instanceof RawClearPassword)) {
            return false;
        }
        RawClearPassword other = (RawClearPassword)obj;
        return password != null && Arrays.equals(password, other.password) && this.getAlgorithm().equals(other.getAlgorithm());
    }
}

