/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import org.jboss.modules.ClassTransformer;

public final class JLIClassTransformer
implements ClassTransformer {
    private final ClassFileTransformer transformer;

    public JLIClassTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("transformer is null");
        }
        this.transformer = transformer;
    }

    @Override
    public ByteBuffer transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, ByteBuffer classBytes) throws IllegalArgumentException {
        byte[] result;
        byte[] bytes;
        int position = classBytes.position();
        int limit = classBytes.limit();
        if (classBytes.hasArray() && classBytes.arrayOffset() == 0 && position == 0 && limit == classBytes.capacity()) {
            bytes = classBytes.array();
        } else {
            bytes = new byte[limit - position];
            classBytes.get(bytes);
            classBytes.position(position);
        }
        try {
            result = this.transformer.transform(loader, className, null, protectionDomain, bytes);
        }
        catch (IllegalClassFormatException e) {
            throw new IllegalArgumentException(e);
        }
        return result == null || result == bytes ? classBytes : ByteBuffer.wrap(result);
    }
}

