/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;

public class AttributeNamePathCompleter
implements CommandLineCompleter {
    private static final Logger LOG = Logger.getLogger(AttributeNamePathCompleter.class);
    private static final AttributeFilter DEFAULT_FILTER = descr -> true;
    public static final AttributeFilter LIST_FILTER = descr -> {
        block9: {
            ModelType type;
            ModelNode mn;
            ModelNode modelNode = mn = descr.has("type") ? descr.get("type") : null;
            if (mn == null) {
                return true;
            }
            try {
                type = mn.asType();
            }
            catch (Exception ex) {
                return true;
            }
            if (type == ModelType.LIST) {
                return true;
            }
            if (type == ModelType.OBJECT) {
                if (descr.has("value-type")) {
                    ModelNode vt = descr.get("value-type");
                    try {
                        ModelType mt = vt.asType();
                        if (mt.equals((Object)ModelType.LIST)) {
                            return true;
                        }
                        break block9;
                    }
                    catch (Exception ex) {
                        return true;
                    }
                }
                return true;
            }
        }
        return false;
    };
    public static final AttributeFilter MAP_FILTER = descr -> {
        block9: {
            ModelType type;
            ModelNode mn;
            ModelNode modelNode = mn = descr.has("type") ? descr.get("type") : null;
            if (mn == null) {
                return true;
            }
            try {
                type = mn.asType();
            }
            catch (Exception ex) {
                return true;
            }
            if (type == ModelType.OBJECT) {
                return true;
            }
            if (type == ModelType.LIST) {
                if (descr.has("value-type")) {
                    ModelNode vt = descr.get("value-type");
                    try {
                        ModelType mt = vt.asType();
                        if (mt.equals((Object)ModelType.LIST)) {
                            return true;
                        }
                        break block9;
                    }
                    catch (Exception ex) {
                        return true;
                    }
                }
                return true;
            }
        }
        return false;
    };
    public static final AttributeNamePathCompleter INSTANCE = new AttributeNamePathCompleter();
    private final OperationRequestAddress address;
    private final ModelNode attrDescr;
    private final boolean writeOnly;
    private final AttributeFilter filter;

    private AttributeNamePathCompleter() {
        this.address = null;
        this.attrDescr = null;
        this.writeOnly = false;
        this.filter = DEFAULT_FILTER;
    }

    public AttributeNamePathCompleter(OperationRequestAddress address, AttributeFilter filter) {
        this(address, false, filter);
    }

    public AttributeNamePathCompleter(OperationRequestAddress address) {
        this(address, null);
    }

    public AttributeNamePathCompleter(OperationRequestAddress address, boolean writeOnly) {
        this(address, writeOnly, null);
    }

    public AttributeNamePathCompleter(OperationRequestAddress address, boolean writeOnly, AttributeFilter filter) {
        this.address = Assert.checkNotNullParam("address", address);
        this.attrDescr = null;
        this.writeOnly = writeOnly;
        this.filter = filter == null ? DEFAULT_FILTER : filter;
    }

    public AttributeNamePathCompleter(ModelNode typeDescr) {
        this(typeDescr, null);
    }

    public AttributeNamePathCompleter(ModelNode typeDescr, AttributeFilter filter) {
        this.attrDescr = Assert.checkNotNullParam("typeDescr", typeDescr);
        this.address = null;
        this.writeOnly = false;
        this.filter = filter == null ? DEFAULT_FILTER : filter;
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        ModelNode descr;
        ModelNode modelNode = descr = this.attrDescr == null ? this.getAttributeDescription(ctx) : this.attrDescr;
        if (descr == null) {
            return -1;
        }
        return this.complete(buffer, candidates, descr, this.writeOnly);
    }

    public int complete(String buffer, List<String> candidates, ModelNode descr) {
        return this.complete(buffer, candidates, descr, this.writeOnly);
    }

    public int complete(String buffer, List<String> candidates, ModelNode descr, boolean writeOnly) {
        AttributeNamePathCallbackHandler handler;
        try {
            handler = this.parse(buffer);
        }
        catch (CommandFormatException e) {
            if (LOG.isEnabled(Logger.Level.WARN)) {
                LOG.log(Logger.Level.WARN, (Object)e.getLocalizedMessage(), e);
            }
            return -1;
        }
        Collection<String> foundCandidates = handler.getCandidates(descr, writeOnly);
        if (foundCandidates.isEmpty()) {
            return -1;
        }
        candidates.addAll(foundCandidates);
        return handler.getCandidateIndex();
    }

    protected AttributeNamePathCallbackHandler parse(String line) throws CommandFormatException {
        AttributeNamePathCallbackHandler namePathHandler = new AttributeNamePathCallbackHandler(false);
        StateParser.parse(line, namePathHandler, InitialValueState.INSTANCE);
        return namePathHandler;
    }

    private static boolean isAttributeNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-';
    }

    private ModelNode getAttributeDescription(CommandContext ctx) {
        ModelNode attrs;
        ModelNode response;
        ModelNode req = new ModelNode();
        ModelNode addrNode = req.get("address");
        for (OperationRequestAddress.Node node : this.address) {
            addrNode.add(node.getType(), node.getName());
        }
        req.get("operation").set("read-resource-description");
        try {
            response = ctx.getModelControllerClient().execute(req);
        }
        catch (Exception e) {
            return null;
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            return null;
        }
        if (result.getType().equals((Object)ModelType.LIST)) {
            ModelNode wildcardResult = null;
            for (ModelNode item : result.asList()) {
                ModelNode addr = item.get("address");
                if (!addr.getType().equals((Object)ModelType.LIST)) {
                    return null;
                }
                for (ModelNode node : addr.asList()) {
                    if (!node.getType().equals((Object)ModelType.PROPERTY)) {
                        throw new IllegalArgumentException(node.getType().toString());
                    }
                    if (!"*".equals(node.asProperty().getValue().asString())) continue;
                    wildcardResult = item;
                    break;
                }
                if (wildcardResult == null) continue;
                break;
            }
            if (wildcardResult == null) {
                throw new IllegalStateException("Failed to locate the wildcard result.");
            }
            if (!(wildcardResult = wildcardResult.get("result")).isDefined()) {
                return null;
            }
            attrs = wildcardResult.get("attributes");
        } else {
            attrs = result.get("attributes");
        }
        if (!attrs.isDefined()) {
            return null;
        }
        return attrs;
    }

    public static class CloseBracketState
    extends DefaultParsingState {
        public static final String ID = "CLS_BR";
        public static final CloseBracketState INSTANCE = new CloseBracketState();

        CloseBracketState() {
            super(ID);
            this.setDefaultHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class OpenBracketState
    extends DefaultParsingState {
        public static final String ID = "OPN_BR";
        public static final OpenBracketState INSTANCE = new OpenBracketState();

        OpenBracketState() {
            super(ID);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(ListIndexState.INSTANCE);
                }
            });
            this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class ListIndexState
    extends DefaultParsingState {
        public static final String ID = "LIST_IND";
        public static final ListIndexState INSTANCE = new ListIndexState();

        public ListIndexState() {
            super(ID);
            this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
            this.enterState(']', CloseBracketState.INSTANCE);
            this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class DotState
    extends DefaultParsingState {
        public static final String ID = "DOT";
        public static final DotState INSTANCE = new DotState();

        public DotState() {
            super(ID);
            this.setDefaultHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class AttributeNameState
    extends DefaultParsingState {
        public static final String ID = "ATTR_NAME";
        public static final AttributeNameState INSTANCE = new AttributeNameState();

        public AttributeNameState() {
            super(ID);
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    char ch = ctx.getCharacter();
                    CharacterHandler handler = this.getHandler(ch);
                    handler.handle(ctx);
                }
            });
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    char c = ctx.getCharacter();
                    WordCharacterHandler.IGNORE_LB_ESCAPE_ON.handle(ctx);
                }
            });
            this.putHandler('.', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
            this.putHandler('[', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
            this.putHandler(']', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class InitialValueState
    extends DefaultParsingState {
        public static final String ID = "INITVAL";
        public static final InitialValueState INSTANCE = new InitialValueState();

        public InitialValueState() {
            this(AttributeNameState.INSTANCE);
        }

        public InitialValueState(final AttributeNameState attrName) {
            super(ID);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(attrName);
                }
            });
            this.enterState('.', DotState.INSTANCE);
            this.enterState('[', OpenBracketState.INSTANCE);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    char c;
                    if (!ctx.isEndOfContent() && (AttributeNamePathCompleter.isAttributeNameChar(c = ctx.getCharacter()) || c == '.' || c == '[' || c == ']')) {
                        this.getHandler(c).handle(ctx);
                    }
                }
            });
        }
    }

    private class AttributeNamePathCallbackHandler
    implements ParsingStateCallbackHandler {
        private static final String offsetStep = "  ";
        private final boolean logging;
        private int offset;
        private String lastEnteredState;
        private char lastStateChar;
        private int candidateIndex;
        private List<String> path = Collections.emptyList();
        private StringBuilder buf = new StringBuilder();

        AttributeNamePathCallbackHandler(boolean logging) {
            this.logging = logging;
        }

        public Collection<String> getCandidates(ModelNode attrsDescr, boolean writeOnly) {
            if (attrsDescr == null || !attrsDescr.isDefined()) {
                return Collections.emptyList();
            }
            ModelNode typeDescr = attrsDescr;
            for (String name : this.path) {
                if (!typeDescr.has(name)) {
                    return Collections.emptyList();
                }
                Iterator descr = typeDescr.get(name);
                if (writeOnly && !this.isWritable((ModelNode)((Object)descr))) {
                    return Collections.emptyList();
                }
                if (!((ModelNode)((Object)descr)).hasDefined("value-type")) {
                    return Collections.emptyList();
                }
                typeDescr = ((ModelNode)((Object)descr)).get("value-type");
                if (typeDescr.getType() == ModelType.OBJECT || typeDescr.getType() == ModelType.PROPERTY) continue;
                return Collections.emptyList();
            }
            Set<String> attrNames = typeDescr.keys();
            ArrayList<String> candidates = new ArrayList<String>(attrNames.size());
            if ("DOT".equals(this.lastEnteredState)) {
                if (writeOnly) {
                    for (String name : attrNames) {
                        if (!this.isWritable(typeDescr.get(name)) || !AttributeNamePathCompleter.this.filter.accept(typeDescr.get(name))) continue;
                        candidates.add(name);
                    }
                } else {
                    for (String name : attrNames) {
                        if (!AttributeNamePathCompleter.this.filter.accept(typeDescr.get(name))) continue;
                        candidates.add(name);
                    }
                }
                Collections.sort(candidates);
                return candidates;
            }
            if ("OPN_BR".equals(this.lastEnteredState) || "LIST_IND".equals(this.lastEnteredState)) {
                return Collections.emptyList();
            }
            if ("CLS_BR".equals(this.lastEnteredState)) {
                return Arrays.asList(".", "=");
            }
            String chunk = this.buf.length() == 0 ? null : this.buf.toString();
            ModelNode chunkDescr = null;
            for (String candidate : attrNames) {
                if (chunk != null && !candidate.startsWith(chunk) || writeOnly && !this.isWritable(typeDescr.get(candidate))) continue;
                if (chunk != null && chunk.length() == candidate.length()) {
                    chunkDescr = typeDescr.get(candidate);
                    continue;
                }
                if (!AttributeNamePathCompleter.this.filter.accept(typeDescr.get(candidate))) continue;
                candidates.add(candidate);
            }
            if (chunkDescr != null && chunkDescr.hasDefined("type")) {
                ModelType modelType = chunkDescr.get("type").asType();
                if (modelType.equals((Object)ModelType.OBJECT)) {
                    if (candidates.isEmpty()) {
                        this.candidateIndex += chunk.length();
                    }
                    candidates.add(".");
                } else if (modelType.equals((Object)ModelType.LIST)) {
                    if (candidates.isEmpty()) {
                        this.candidateIndex += chunk.length();
                    }
                    candidates.add("[");
                } else if (modelType.equals((Object)ModelType.STRING) || modelType.equals((Object)ModelType.INT) || modelType.equals((Object)ModelType.BOOLEAN)) {
                    if (candidates.isEmpty()) {
                        this.candidateIndex += chunk.length();
                    }
                    candidates.add("");
                }
            }
            Collections.sort(candidates);
            return candidates;
        }

        private boolean isWritable(ModelNode attrDescr) {
            return !this.isReadOnly(attrDescr);
        }

        private boolean isReadOnly(ModelNode attrDescr) {
            return attrDescr.has("access-type") && ("read-only".equals(attrDescr.get("access-type").asString()) || "metric".equals(attrDescr.get("access-type").asString()));
        }

        public int getCandidateIndex() {
            switch (this.lastStateChar) {
                case '.': 
                case '[': 
                case ']': {
                    return this.candidateIndex + 1;
                }
            }
            return this.candidateIndex;
        }

        @Override
        public void enteredState(ParsingContext ctx) throws CommandFormatException {
            String prevEnteredState = this.lastEnteredState;
            this.lastEnteredState = ctx.getState().getId();
            this.candidateIndex = ctx.getLocation();
            this.lastStateChar = ctx.getCharacter();
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("entered '" + ctx.getCharacter() + "' " + ctx.getState().getId());
                System.out.println(buf.toString());
            }
            if (!"CLS_BR".equals(prevEnteredState) && this.isNameSeparator()) {
                if (this.buf.length() == 0) {
                    throw new CommandFormatException("Attribute name is missing before " + this.lastStateChar + " at index " + ctx.getLocation() + " in '" + ctx.getInput() + "'");
                }
                switch (this.path.size()) {
                    case 0: {
                        this.path = Collections.singletonList(this.buf.toString());
                        break;
                    }
                    case 1: {
                        this.path = new ArrayList<String>(this.path);
                    }
                    default: {
                        this.path.add(this.buf.toString());
                    }
                }
                this.buf.setLength(0);
            }
        }

        private boolean isNameSeparator() {
            return this.lastEnteredState.equals("DOT") || this.lastEnteredState.equals("OPN_BR");
        }

        @Override
        public void leavingState(ParsingContext ctx) throws CommandFormatException {
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("leaving '" + ctx.getCharacter() + "' " + ctx.getState().getId());
                System.out.println(buf.toString());
            }
            if (ctx.getState().getId().equals("LIST_IND")) {
                this.buf.setLength(0);
            }
        }

        @Override
        public void character(ParsingContext ctx) throws CommandFormatException {
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("char '" + ctx.getCharacter() + "' " + ctx.getState().getId());
                System.out.println(buf.toString());
            }
            this.buf.append(ctx.getCharacter());
        }
    }

    public static interface AttributeFilter {
        public boolean accept(ModelNode var1);
    }
}

