/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.MessageDigest;
import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.RawPassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;

class RawScramDigestPassword
extends RawPassword
implements ScramDigestPassword {
    private static final long serialVersionUID = -6829330384649271844L;
    private final byte[] digest;
    private final byte[] salt;
    private final int iterationCount;

    RawScramDigestPassword(String algorithm, byte[] digest, byte[] salt, int iterationCount) {
        super(algorithm);
        this.digest = digest;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public RawScramDigestPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.digest), Arrays.hashCode(this.salt)), this.iterationCount), this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawScramDigestPassword)) {
            return false;
        }
        RawScramDigestPassword other = (RawScramDigestPassword)obj;
        return this.iterationCount == other.iterationCount && this.getAlgorithm().equals(other.getAlgorithm()) && MessageDigest.isEqual(this.digest, other.digest) && Arrays.equals(this.salt, other.salt);
    }
}

