/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

public class ProtocolConnectionUtils {
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final String REMOTE_PROTOCOL = "remote";

    public static IoFuture<Connection> connect(ProtocolConnectionConfiguration configuration) throws IOException {
        return ProtocolConnectionUtils.connect(configuration.getCallbackHandler(), configuration);
    }

    private static IoFuture<Connection> connect(CallbackHandler handler, ProtocolConnectionConfiguration configuration) throws IOException {
        Endpoint endpoint = configuration.getEndpoint();
        OptionMap options = ProtocolConnectionUtils.getOptions(configuration);
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        String clientBindAddress = configuration.getClientBindAddress();
        if (clientBindAddress == null) {
            return endpoint.connect(configuration.getUri(), options, actualHandler, configuration.getSslContext());
        }
        InetSocketAddress bindAddr = new InetSocketAddress(clientBindAddress, 0);
        InetSocketAddress destAddr = new InetSocketAddress(configuration.getUri().getHost(), configuration.getUri().getPort());
        return endpoint.connect(REMOTE_PROTOCOL, (SocketAddress)bindAddr, (SocketAddress)destAddr, options, actualHandler, configuration.getSslContext());
    }

    public static Connection connectSync(ProtocolConnectionConfiguration configuration) throws IOException {
        CallbackHandler handler = configuration.getCallbackHandler();
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        WrapperCallbackHandler wrapperHandler = new WrapperCallbackHandler(actualHandler);
        IoFuture<Connection> future = ProtocolConnectionUtils.connect(wrapperHandler, configuration);
        long timeoutMillis = configuration.getConnectionTimeout();
        IoFuture.Status status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
        while (status == IoFuture.Status.WAITING) {
            if (wrapperHandler.isInCall()) {
                status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
                continue;
            }
            long lastInteraction = wrapperHandler.getCallFinished();
            if (lastInteraction > 0L) {
                long now = System.currentTimeMillis();
                long timeSinceLast = now - lastInteraction;
                if (timeSinceLast < timeoutMillis) {
                    status = future.await(timeoutMillis - timeSinceLast, TimeUnit.MILLISECONDS);
                    continue;
                }
                status = null;
                continue;
            }
            status = null;
        }
        if (status == IoFuture.Status.DONE) {
            return (Connection)future.get();
        }
        if (status == IoFuture.Status.FAILED) {
            throw ProtocolMessages.MESSAGES.failedToConnect(configuration.getUri(), future.getException());
        }
        throw ProtocolMessages.MESSAGES.couldNotConnect(configuration.getUri());
    }

    private static OptionMap getOptions(ProtocolConnectionConfiguration configuration) {
        Map<String, String> saslOptions = configuration.getSaslOptions();
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(configuration.getOptionMap());
        builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
        ProtocolConnectionUtils.configureSaslMechnisms(saslOptions, ProtocolConnectionUtils.isLocal(configuration.getUri()), builder);
        ArrayList<Property> tempProperties = new ArrayList<Property>(saslOptions != null ? saslOptions.size() : 1);
        tempProperties.add(Property.of((String)"jboss.sasl.local-user.quiet-auth", (String)"true"));
        if (saslOptions != null) {
            for (String currentKey : saslOptions.keySet()) {
                tempProperties.add(Property.of((String)currentKey, (String)saslOptions.get(currentKey)));
            }
        }
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(tempProperties));
        builder.set(Options.SSL_ENABLED, true);
        builder.set(Options.SSL_STARTTLS, true);
        return builder.getMap();
    }

    private static void configureSaslMechnisms(Map<String, String> saslOptions, boolean isLocal, OptionMap.Builder builder) {
        Object[] split;
        String listed;
        String[] mechanisms = null;
        if (saslOptions != null && (listed = saslOptions.get(Options.SASL_DISALLOWED_MECHANISMS.getName())) != null) {
            split = listed.split(" ");
            if (isLocal) {
                mechanisms = new String[split.length + 1];
                mechanisms[0] = JBOSS_LOCAL_USER;
                System.arraycopy(split, 0, mechanisms, 1, split.length);
            } else {
                mechanisms = split;
            }
        } else if (!isLocal) {
            mechanisms = new String[]{JBOSS_LOCAL_USER};
        }
        if (mechanisms != null) {
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of(mechanisms));
        }
        if (saslOptions != null && (listed = saslOptions.get(Options.SASL_MECHANISMS.getName())) != null && (split = listed.split(" ")).length > 0) {
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of((Object[])split));
        }
    }

    private static boolean isLocal(URI uri) {
        try {
            NetworkInterface nic;
            String hostName = uri.getHost();
            InetAddress address = InetAddress.getByName(hostName);
            if (address.isLinkLocalAddress()) {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                nic = null;
                while (interfaces.hasMoreElements() && nic == null) {
                    NetworkInterface current = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = current.getInetAddresses();
                    while (addresses.hasMoreElements() && nic == null) {
                        InetAddress currentAddress = addresses.nextElement();
                        if (!address.equals(currentAddress)) continue;
                        nic = current;
                    }
                }
            } else {
                nic = NetworkInterface.getByInetAddress(address);
            }
            return address.isLoopbackAddress() || nic != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }

    private static final class WrapperCallbackHandler
    implements CallbackHandler {
        private volatile boolean inCall = false;
        private volatile long callFinished = -1L;
        private final CallbackHandler wrapped;

        WrapperCallbackHandler(CallbackHandler toWrap) {
            this.wrapped = toWrap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            this.inCall = true;
            try {
                this.wrapped.handle(callbacks);
            }
            finally {
                this.callFinished = System.currentTimeMillis();
                this.inCall = false;
            }
        }

        boolean isInCall() {
            return this.inCall;
        }

        long getCallFinished() {
            return this.callFinished;
        }
    }
}

