/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.GenericOutboundConnectionAdd;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

class RemotingSubsystem11Parser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static final RemotingSubsystem11Parser INSTANCE = new RemotingSubsystem11Parser();

    RemotingSubsystem11Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "remoting");
        address.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
        list.add(subsystem);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            boolean doneWorkerThreadPool = false;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKER_THREAD_POOL: {
                    if (doneWorkerThreadPool) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.WORKER_THREAD_POOL.getLocalName());
                    }
                    doneWorkerThreadPool = true;
                    this.parseWorkerThreadPool(reader, subsystem);
                    continue block5;
                }
                case CONNECTOR: {
                    this.parseConnector(reader, address, list);
                    continue block5;
                }
                case OUTBOUND_CONNECTIONS: {
                    this.parseOutboundConnections(reader, address, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseWorkerThreadPool(XMLExtendedStreamReader reader, ModelNode subsystemAdd) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case WORKER_READ_THREADS: {
                    if (subsystemAdd.hasDefined("worker-read-threads")) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-read-threads");
                    }
                    RemotingSubsystemRootResource.WORKER_READ_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case WORKER_TASK_CORE_THREADS: {
                    if (subsystemAdd.hasDefined("worker-task-core-threads")) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-core-threads");
                    }
                    RemotingSubsystemRootResource.WORKER_TASK_CORE_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case WORKER_TASK_KEEPALIVE: {
                    if (subsystemAdd.hasDefined("worker-task-keepalive")) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-keepalive");
                    }
                    RemotingSubsystemRootResource.WORKER_TASK_KEEPALIVE.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case WORKER_TASK_LIMIT: {
                    if (subsystemAdd.hasDefined("worker-task-limit")) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-limit");
                    }
                    RemotingSubsystemRootResource.WORKER_TASK_LIMIT.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case WORKER_TASK_MAX_THREADS: {
                    if (subsystemAdd.hasDefined("worker-task-max-threads")) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-max-threads");
                    }
                    RemotingSubsystemRootResource.WORKER_TASK_MAX_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case WORKER_WRITE_THREADS: {
                    if (subsystemAdd.hasDefined("worker-write-threads")) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-write-threads");
                    }
                    RemotingSubsystemRootResource.WORKER_WRITE_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String securityRealm = null;
        String socketBinding = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block10;
                }
                case SOCKET_BINDING: {
                    socketBinding = value;
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        assert (socketBinding != null);
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        connector.get("address").set(address).add("connector", name);
        connector.get("socket-binding").set(socketBinding);
        if (securityRealm != null) {
            connector.get("security-realm").set(securityRealm);
        }
        list.add(connector);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSaslElement(reader, connector.get("address"), list);
                    continue block11;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, connector.get("address"), list);
                    continue block11;
                }
                case AUTHENTICATION_PROVIDER: {
                    connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSaslElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode saslElement = new ModelNode();
        saslElement.get("operation").set("add");
        saslElement.get("address").set(address).add(SaslResource.SASL_CONFIG_PATH.getKey(), SaslResource.SASL_CONFIG_PATH.getValue());
        list.add(saslElement);
        int count = reader.getAttributeCount();
        if (count > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case INCLUDE_MECHANISMS: {
                    ModelNode includes = saslElement.get("include-mechanisms");
                    for (String s : (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                        includes.add().set(s);
                    }
                    continue block13;
                }
                case POLICY: {
                    this.parsePolicyElement(reader, saslElement.get("address"), list);
                    break;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, saslElement.get("address"), list);
                    break;
                }
                case QOP: {
                    String[] qop;
                    for (String q : qop = (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                        try {
                            saslElement.get("qop").add(SaslQop.fromString((String)q).getString().toLowerCase(Locale.ENGLISH));
                        }
                        catch (IllegalArgumentException e) {
                            throw RemotingMessages.MESSAGES.invalidQOPV(q);
                        }
                    }
                    continue block13;
                }
                case REUSE_SESSION: {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    SaslResource.REUSE_SESSION_ATTRIBUTE.parseAndSetParameter(value, saslElement, (XMLStreamReader)reader);
                    break;
                }
                case SERVER_AUTH: {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    SaslResource.SERVER_AUTH_ATTRIBUTE.parseAndSetParameter(value, saslElement, (XMLStreamReader)reader);
                    break;
                }
                case STRENGTH: {
                    String[] strength;
                    for (String s : strength = (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                        try {
                            saslElement.get("strength").add(SaslStrength.valueOf((String)s.toUpperCase(Locale.ENGLISH)).name().toLowerCase(Locale.ENGLISH));
                        }
                        catch (IllegalArgumentException e) {
                            throw RemotingMessages.MESSAGES.invalidStrength(s);
                        }
                    }
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    ModelNode parsePolicyElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode policy = new ModelNode();
        policy.get("operation").set("add");
        policy.get("address").set(address).add(SaslPolicyResource.SASL_POLICY_CONFIG_PATH.getKey(), SaslPolicyResource.SASL_POLICY_CONFIG_PATH.getValue());
        list.add(policy);
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case FORWARD_SECRECY: {
                    SaslPolicyResource.FORWARD_SECRECY.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_ACTIVE: {
                    SaslPolicyResource.NO_ACTIVE.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_ANONYMOUS: {
                    SaslPolicyResource.NO_ANONYMOUS.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_DICTIONARY: {
                    SaslPolicyResource.NO_DICTIONARY.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_PLAIN_TEXT: {
                    SaslPolicyResource.NO_PLAIN_TEXT.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case PASS_CREDENTIALS: {
                    SaslPolicyResource.PASS_CREDENTIALS.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return policy;
    }

    private void parseProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            reader.require(1, Namespace.REMOTING_1_1.getUriString(), Element.PROPERTY.getLocalName());
            Property property = ParseUtils.readProperty((XMLExtendedStreamReader)reader, (boolean)true);
            ModelNode propertyOp = new ModelNode();
            propertyOp.get("operation").set("add");
            propertyOp.get("address").set(address).add("property", property.getName());
            propertyOp.get("value").set(property.getValue());
            list.add(propertyOp);
        }
    }

    private void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_OUTBOUND_CONNECTION: {
                    this.parseRemoteOutboundConnection(reader, address, operations);
                    continue block5;
                }
                case LOCAL_OUTBOUND_CONNECTION: {
                    this.parseLocalOutboundConnection(reader, address, operations);
                    continue block5;
                }
                case OUTBOUND_CONNECTION: {
                    this.parseOutboundConnection(reader, address, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        String name = null;
        String outboundSocketBindingRef = null;
        ModelNode username = null;
        String securityRealm = null;
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    outboundSocketBindingRef = value;
                    continue block9;
                }
                case USERNAME: {
                    username = RemoteOutboundConnectionResourceDefinition.USERNAME.parse(value, (XMLStreamReader)reader);
                    continue block9;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"remote-outbound-connection", name)});
        ModelNode connectionAddOperation = RemotingSubsystem11Parser.getConnectionAddOperation(name, outboundSocketBindingRef, username, securityRealm, address);
        operations.add(connectionAddOperation);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLocalOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        String name = null;
        String outboundSocketBindingRef = null;
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    outboundSocketBindingRef = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"local-outbound-connection", name)});
        operations.add(RemotingSubsystem11Parser.getConnectionAddOperation(name, outboundSocketBindingRef, address));
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URI);
        int count = reader.getAttributeCount();
        String name = null;
        String uri = null;
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case URI: {
                    uri = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"outbound-connection", name)});
        operations.add(GenericOutboundConnectionAdd.getAddOperation(name, uri, address));
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode getConnectionAddOperation(String connectionName, String outboundSocketBindingRef, PathAddress address) {
        return RemotingSubsystem11Parser.getConnectionAddOperation(connectionName, outboundSocketBindingRef, null, null, address);
    }

    static ModelNode getConnectionAddOperation(String connectionName, String outboundSocketBindingRef, ModelNode userName, String securityRealm, PathAddress address) {
        if (connectionName == null || connectionName.trim().isEmpty()) {
            throw RemotingMessages.MESSAGES.connectionNameEmpty();
        }
        if (outboundSocketBindingRef == null || outboundSocketBindingRef.trim().isEmpty()) {
            throw RemotingMessages.MESSAGES.outboundSocketBindingEmpty(connectionName);
        }
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        addOperation.get("address").set(address.toModelNode());
        addOperation.get("outbound-socket-binding-ref").set(outboundSocketBindingRef);
        if (userName != null) {
            addOperation.get("username").set(userName);
        }
        if (securityRealm != null) {
            addOperation.get("security-realm").set(securityRealm);
        }
        return addOperation;
    }
}

