/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystem10Parser;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.as.remoting.RemotingSubsystem20Parser;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.RemotingSubsystemXMLPersister;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";
    private static final String RESOURCE_NAME = RemotingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String NODE_NAME_PROPERTY = "jboss.node.name";
    static final SensitivityClassification REMOTING_SECURITY = new SensitivityClassification("remoting", "remoting-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition REMOTING_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(REMOTING_SECURITY);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 2;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion VERSION_1_1 = ModelVersion.create((int)1, (int)1);
    private static final ModelVersion VERSION_1_2 = ModelVersion.create((int)1, (int)2);
    private static final ModelVersion VERSION_1_3 = ModelVersion.create((int)1, (int)3);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, RemotingExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 2, 0, 0);
        registration.registerXMLElementWriter((XMLElementWriter)RemotingSubsystemXMLPersister.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new RemotingSubsystemRootResource(context.getProcessType()));
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)RemotingEndpointResource.INSTANCE);
        ManagementResourceRegistration connector = subsystem.registerSubModel((ResourceDefinition)ConnectorResource.INSTANCE);
        connector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration sasl = connector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE);
        sasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE);
        sasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration httpConnector = subsystem.registerSubModel((ResourceDefinition)HttpConnectorResource.INSTANCE);
        httpConnector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_HTTP_CONNECTOR);
        ManagementResourceRegistration httpSasl = httpConnector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE);
        httpSasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE);
        httpSasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_HTTP_CONNECTOR);
        subsystem.registerSubModel((ResourceDefinition)RemoteOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)LocalOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)GenericOutboundConnectionResourceDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_1(registration);
            this.registerTransformers_1_2(registration);
            this.registerTransformers_1_3(registration);
        }
    }

    private void registerTransformers_1_1(SubsystemRegistration registration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, RemotingSubsystemRootResource.ATTRIBUTES);
        builder.rejectChildResource(HttpConnectorResource.PATH);
        RemotingExtension.endpointTransform(builder);
        ResourceTransformationDescriptionBuilder connector = builder.addChildResource(ConnectorResource.PATH);
        connector.addChildResource(PropertyResource.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{PropertyResource.VALUE});
        ResourceTransformationDescriptionBuilder sasl = connector.addChildResource(SaslResource.SASL_CONFIG_PATH);
        sasl.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, SaslResource.ATTRIBUTES);
        sasl.addChildResource((ResourceDefinition)SaslPolicyResource.INSTANCE).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])SaslPolicyResource.ATTRIBUTES);
        sasl.addChildResource(PropertyResource.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{PropertyResource.VALUE});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)RemotingExtension.protocolTransform(builder.addChildResource(RemoteOutboundConnectionResourceDefinition.ADDRESS).getAttributeBuilder()).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.USERNAME})).end().addChildResource(PropertyResource.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{PropertyResource.VALUE})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(LocalOutboundConnectionResourceDefinition.ADDRESS).addChildResource(PropertyResource.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{PropertyResource.VALUE})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(GenericOutboundConnectionResourceDefinition.ADDRESS).addChildResource(PropertyResource.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{PropertyResource.VALUE})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)registration, (ModelVersionRange)VERSION_1_1);
    }

    private void registerTransformers_1_2(SubsystemRegistration registration) {
        TransformationDescription.Tools.register((TransformationDescription)RemotingExtension.get1_2_0_1_3_0Description(), (SubsystemRegistration)registration, (ModelVersionRange)VERSION_1_2);
    }

    private void registerTransformers_1_3(SubsystemRegistration registration) {
        TransformationDescription.Tools.register((TransformationDescription)RemotingExtension.get1_2_0_1_3_0Description(), (SubsystemRegistration)registration, (ModelVersionRange)VERSION_1_3);
    }

    private static TransformationDescription get1_2_0_1_3_0Description() {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.rejectChildResource(HttpConnectorResource.PATH);
        RemotingExtension.endpointTransform(builder);
        RemotingExtension.protocolTransform(builder.addChildResource(RemoteOutboundConnectionResourceDefinition.ADDRESS).getAttributeBuilder());
        return builder.build();
    }

    private static AttributeTransformationDescriptionBuilder protocolTransform(AttributeTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)builder.setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(Protocol.REMOTE.toString())}), new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.PROTOCOL});
        return builder;
    }

    private static ResourceTransformationDescriptionBuilder endpointTransform(ResourceTransformationDescriptionBuilder parent) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)parent.addChildResource(RemotingEndpointResource.ENDPOINT_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, RemotingEndpointResource.ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.DEFINED, RemotingEndpointResource.ATTRIBUTES.toArray(new AttributeDefinition[RemotingEndpointResource.ATTRIBUTES.size()]))).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD).end().setCustomResourceTransformer(ResourceTransformer.DISCARD);
        return parent;
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_0.getUriString(), (XMLElementReader)RemotingSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_1.getUriString(), (XMLElementReader)RemotingSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_2_0.getUriString(), (XMLElementReader)RemotingSubsystem20Parser.INSTANCE);
    }
}

