/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager.deployment;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.security.ModularPermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.wildfly.extension.security.manager.logging.SecurityManagerLogger;

public class PermissionsParser
extends MetaDataElementParser {
    public static List<PermissionFactory> parse(XMLStreamReader reader, ModuleLoader loader, ModuleIdentifier identifier) throws XMLStreamException {
        reader.require(7, null, null);
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PERMISSIONS: {
                            return PermissionsParser.parsePermissions(reader, loader, identifier);
                        }
                    }
                    throw MetaDataElementParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            throw PermissionsParser.unexpectedContent(reader);
        }
        throw PermissionsParser.endOfDocument(reader.getLocation());
    }

    private static List<PermissionFactory> parsePermissions(XMLStreamReader reader, ModuleLoader loader, ModuleIdentifier identifier) throws XMLStreamException {
        ArrayList<PermissionFactory> factories = new ArrayList<PermissionFactory>();
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.VERSION);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    String version = reader.getAttributeValue(i);
                    if ("7".equals(version)) break;
                    throw SecurityManagerLogger.ROOT_LOGGER.invalidPermissionsXMLVersion(version, "7");
                }
                default: {
                    throw MetaDataElementParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw MetaDataElementParser.missingRequired((XMLStreamReader)reader, requiredAttributes);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return factories;
                }
                case 1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PERMISSION: {
                            PermissionFactory factory = PermissionsParser.parsePermission(reader, loader, identifier);
                            factories.add(factory);
                            continue block11;
                        }
                    }
                    throw MetaDataElementParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            throw PermissionsParser.unexpectedContent(reader);
        }
        throw PermissionsParser.endOfDocument(reader.getLocation());
    }

    private static PermissionFactory parsePermission(XMLStreamReader reader, ModuleLoader loader, ModuleIdentifier identifier) throws XMLStreamException {
        MetaDataElementParser.requireNoAttributes((XMLStreamReader)reader);
        String permissionClass = null;
        String permissionName = null;
        String permissionActions = null;
        EnumSet<Element> requiredElements = EnumSet.of(Element.CLASS_NAME);
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!requiredElements.isEmpty()) {
                        throw PermissionsParser.missingRequiredElement((XMLStreamReader)reader, requiredElements);
                    }
                    ModularPermissionFactory factory = new ModularPermissionFactory(loader, identifier, permissionClass, permissionName, permissionActions);
                    return factory;
                }
                case 1: {
                    Element element = Element.forName(reader.getLocalName());
                    requiredElements.remove((Object)element);
                    switch (element) {
                        case CLASS_NAME: {
                            MetaDataElementParser.requireNoAttributes((XMLStreamReader)reader);
                            permissionClass = reader.getElementText();
                            continue block9;
                        }
                        case NAME: {
                            MetaDataElementParser.requireNoAttributes((XMLStreamReader)reader);
                            permissionName = reader.getElementText();
                            continue block9;
                        }
                        case ACTIONS: {
                            MetaDataElementParser.requireNoAttributes((XMLStreamReader)reader);
                            permissionActions = reader.getElementText();
                            continue block9;
                        }
                    }
                    throw MetaDataElementParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            throw PermissionsParser.unexpectedContent(reader);
        }
        throw PermissionsParser.endOfDocument(reader.getLocation());
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    static enum Attribute {
        UNKNOWN(null),
        VERSION("version");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute attribute = MAP.get(localName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                String name = attribute.name;
                if (name == null) continue;
                map.put(name, attribute);
            }
            MAP = map;
        }
    }

    static enum Element {
        UNKNOWN(null),
        PERMISSIONS("permissions"),
        PERMISSION("permission"),
        CLASS_NAME("class-name"),
        NAME("name"),
        ACTIONS("actions");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

