package org.jboss.as.security.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.security.vault.SecurityVaultException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import javax.naming.InvalidNameException;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.naming.OperationNotSupportedException;
import javax.annotation.Generated;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import java.lang.reflect.Method;
import java.lang.Exception;
import javax.xml.stream.XMLStreamException;
import java.lang.Throwable;
import javax.security.auth.login.LoginException;
import java.util.Arrays;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-13T17:27:10-0600")
public class SecurityLogger_$logger extends DelegatingBasicLogger implements SecurityLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityLogger_$logger.class.getName();
    public SecurityLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void currentVersion(final String version) {
        super.log.logf(FQCN, INFO, null, currentVersion$str(), version);
    }
    private static final String currentVersion = "WFLYSEC0001: Current PicketBox version=%s";
    protected String currentVersion$str() {
        return currentVersion;
    }
    @Override
    public final void activatingSecuritySubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSecuritySubsystem$str());
    }
    private static final String activatingSecuritySubsystem = "WFLYSEC0002: Activating Security Subsystem";
    protected String activatingSecuritySubsystem$str() {
        return activatingSecuritySubsystem;
    }
    @Override
    public final void errorDeletingJACCPolicy(final Throwable t) {
        super.log.logf(FQCN, WARN, t, errorDeletingJACCPolicy$str());
    }
    private static final String errorDeletingJACCPolicy = "WFLYSEC0003: Error deleting JACC Policy";
    protected String errorDeletingJACCPolicy$str() {
        return errorDeletingJACCPolicy;
    }
    private static final String unableToGetModuleClassLoader = "WFLYSEC0004: Unable to get the Module Class Loader";
    protected String unableToGetModuleClassLoader$str() {
        return unableToGetModuleClassLoader;
    }
    @Override
    public final IllegalStateException unableToGetModuleClassLoader(final Throwable e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToGetModuleClassLoader$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNotSupported = "WFLYSEC0005: Operation not supported : %s";
    protected String operationNotSupported$str() {
        return operationNotSupported;
    }
    @Override
    public final OperationNotSupportedException operationNotSupported(final Method method) {
        final OperationNotSupportedException result = new OperationNotSupportedException(String.format(getLoggingLocale(), operationNotSupported$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingModuleName = "WFLYSEC0006: Missing module name for the %s";
    protected String missingModuleName$str() {
        return missingModuleName;
    }
    @Override
    public final IllegalArgumentException missingModuleName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingModuleName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String runtimeException = "WFLYSEC0007: Runtime Exception:";
    protected String runtimeException$str() {
        return runtimeException;
    }
    @Override
    public final RuntimeException runtimeException(final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), runtimeException$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullName = "WFLYSEC0009: Name cannot be null or empty";
    protected String nullName$str() {
        return nullName;
    }
    @Override
    public final InvalidNameException nullName() {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), nullName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullArgument = "WFLYSEC0011: Argument %s is null";
    protected String nullArgument$str() {
        return nullArgument;
    }
    @Override
    public final IllegalArgumentException nullArgument(final String arg) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullArgument$str(), arg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToStartException = "WFLYSEC0012: Unable to start the %s service";
    protected String unableToStartException$str() {
        return unableToStartException;
    }
    @Override
    public final StartException unableToStartException(final String service, final Throwable t) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToStartException$str(), service), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cnfe = "WFLYSEC0013: Class not found : %s";
    protected String cnfe$str() {
        return cnfe;
    }
    @Override
    public final ClassNotFoundException cnfe(final String name) {
        final ClassNotFoundException result = new ClassNotFoundException(String.format(getLoggingLocale(), cnfe$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityException = "WFLYSEC0015: Security Exception";
    protected String securityException$str() {
        return securityException;
    }
    @Override
    public final SecurityException securityException(final Throwable t) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), securityException$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String vaultReaderException = "WFLYSEC0017: Vault Reader Exception:";
    protected String vaultReaderException$str() {
        return vaultReaderException;
    }
    @Override
    public final VaultReaderException vaultReaderException(final Throwable t) {
        final VaultReaderException result = new VaultReaderException(String.format(getLoggingLocale(), vaultReaderException$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedOperationExceptionUseResourceDesc = "WFLYSEC0018: Use the ResourceDescriptionResolver variant";
    protected String unsupportedOperationExceptionUseResourceDesc$str() {
        return unsupportedOperationExceptionUseResourceDesc;
    }
    @Override
    public final UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedOperationExceptionUseResourceDesc$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedOperation = "WFLYSEC0019: Unsupported Operation";
    protected String unsupportedOperation$str() {
        return unsupportedOperation;
    }
    @Override
    public final UnsupportedOperationException unsupportedOperation() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlStreamExceptionAuth = "WFLYSEC0022: A security domain can have either an <authentication> or <authentication-jaspi> element, not both";
    protected String xmlStreamExceptionAuth$str() {
        return xmlStreamExceptionAuth;
    }
    @Override
    public final XMLStreamException xmlStreamExceptionAuth(final Location loc) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), xmlStreamExceptionAuth$str()), loc);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlStreamExceptionMissingAttribute = "WFLYSEC0023: Missing required attribute: either %s or %s must be present";
    protected String xmlStreamExceptionMissingAttribute$str() {
        return xmlStreamExceptionMissingAttribute;
    }
    @Override
    public final XMLStreamException xmlStreamExceptionMissingAttribute(final String a, final String b, final Location loc) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), xmlStreamExceptionMissingAttribute$str(), a, b), loc);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String loginModuleStackIllegalArgument = "WFLYSEC0024: auth-module references a login module stack that doesn't exist::%s";
    protected String loginModuleStackIllegalArgument$str() {
        return loginModuleStackIllegalArgument;
    }
    @Override
    public final IllegalArgumentException loginModuleStackIllegalArgument(final String str) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), loginModuleStackIllegalArgument$str(), str));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String addressDidNotContainSecurityDomain = "WFLYSEC0025: Address did not contain a security domain name";
    protected String addressDidNotContainSecurityDomain$str() {
        return addressDidNotContainSecurityDomain;
    }
    @Override
    public final IllegalArgumentException addressDidNotContainSecurityDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), addressDidNotContainSecurityDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String vaultNotInitializedException = "WFLYSEC0026: Vault is not initialized";
    protected String vaultNotInitializedException$str() {
        return vaultNotInitializedException;
    }
    @Override
    public final SecurityException vaultNotInitializedException() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), vaultNotInitializedException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUserException = "WFLYSEC0027: Invalid User";
    protected String invalidUserException$str() {
        return invalidUserException;
    }
    @Override
    public final SecurityException invalidUserException() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), invalidUserException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityManagementNotInjected = "WFLYSEC0028: Security Management not injected";
    protected String securityManagementNotInjected$str() {
        return securityManagementNotInjected;
    }
    @Override
    public final SecurityException securityManagementNotInjected() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), securityManagementNotInjected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmNotFound = "WFLYSEC0029: Security realm '%s' not found.";
    protected String realmNotFound$str() {
        return realmNotFound;
    }
    @Override
    public final SecurityException realmNotFound(final String name) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), realmNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failureCallingSecurityRealm = "WFLYSEC0031: Failure calling CallbackHandler '%s'";
    protected String failureCallingSecurityRealm$str() {
        return failureCallingSecurityRealm;
    }
    @Override
    public final LoginException failureCallingSecurityRealm(final String cause) {
        final LoginException result = new LoginException(String.format(getLoggingLocale(), failureCallingSecurityRealm$str(), cause));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAuthenticationCacheAvailable = "WFLYSEC0032: No authentication cache for security domain '%s' available";
    protected String noAuthenticationCacheAvailable$str() {
        return noAuthenticationCacheAvailable;
    }
    @Override
    public final OperationFailedException noAuthenticationCacheAvailable(final String securityDomain) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noAuthenticationCacheAvailable$str(), securityDomain));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noUserPrincipalFound = "WFLYSEC0033: No UserPrincipalFound constructing RemotingConnectionPrincipal.";
    protected String noUserPrincipalFound$str() {
        return noUserPrincipalFound;
    }
    @Override
    public final IllegalStateException noUserPrincipalFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noUserPrincipalFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedWaitingForSecurityDomain = "WFLYSEC0034: Interrupted waiting for security domain '%s'";
    protected String interruptedWaitingForSecurityDomain$str() {
        return interruptedWaitingForSecurityDomain;
    }
    @Override
    public final OperationFailedException interruptedWaitingForSecurityDomain(final String securityDomainName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), interruptedWaitingForSecurityDomain$str(), securityDomainName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredSecurityDomainServiceNotAvailable = "WFLYSEC0035: Required security domain is not available '%s'";
    protected String requiredSecurityDomainServiceNotAvailable$str() {
        return requiredSecurityDomainServiceNotAvailable;
    }
    @Override
    public final OperationFailedException requiredSecurityDomainServiceNotAvailable(final String securityDomainName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredSecurityDomainServiceNotAvailable$str(), securityDomainName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreDoesnotExistWithExample = "WFLYSEC0037: Keystore '%s' doesn't exist.\nkeystore could be created: keytool -genseckey -alias Vault -storetype jceks -keyalg AES -keysize 128 -storepass secretsecret -keypass secretsecret -keystore %s";
    protected String keyStoreDoesnotExistWithExample$str() {
        return keyStoreDoesnotExistWithExample;
    }
    @Override
    public final Exception keyStoreDoesnotExistWithExample(final String keystoreURL, final String keystoreURLExample) {
        final Exception result = new Exception(String.format(getLoggingLocale(), keyStoreDoesnotExistWithExample$str(), keystoreURL, keystoreURLExample));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreNotWritable = "WFLYSEC0038: Keystore [%s] is not writable or not a file.";
    protected String keyStoreNotWritable$str() {
        return keyStoreNotWritable;
    }
    @Override
    public final Exception keyStoreNotWritable(final String keystoreURL) {
        final Exception result = new Exception(String.format(getLoggingLocale(), keyStoreNotWritable$str(), keystoreURL));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStorePasswordNotSpecified = "WFLYSEC0039: Keystore password has to be specified.";
    protected String keyStorePasswordNotSpecified$str() {
        return keyStorePasswordNotSpecified;
    }
    @Override
    public final Exception keyStorePasswordNotSpecified() {
        final Exception result = new Exception(String.format(getLoggingLocale(), keyStorePasswordNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String encryptionDirectoryDoesNotExist = "WFLYSEC0041: Encryption directory is not a directory or doesn't exist. (%s)";
    protected String encryptionDirectoryDoesNotExist$str() {
        return encryptionDirectoryDoesNotExist;
    }
    @Override
    public final Exception encryptionDirectoryDoesNotExist(final String directory) {
        final Exception result = new Exception(String.format(getLoggingLocale(), encryptionDirectoryDoesNotExist$str(), directory));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateEncryptionDirectory = "WFLYSEC0042: Cannot create encryption directory %s";
    protected String cannotCreateEncryptionDirectory$str() {
        return cannotCreateEncryptionDirectory;
    }
    @Override
    public final Exception cannotCreateEncryptionDirectory(final String directory) {
        final Exception result = new Exception(String.format(getLoggingLocale(), cannotCreateEncryptionDirectory$str(), directory));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String iterationCountOutOfRange = "WFLYSEC0043: Iteration count has to be within 1 - 2147483647, but it is %s.";
    protected String iterationCountOutOfRange$str() {
        return iterationCountOutOfRange;
    }
    @Override
    public final Exception iterationCountOutOfRange(final String iteration) {
        final Exception result = new Exception(String.format(getLoggingLocale(), iterationCountOutOfRange$str(), iteration));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String saltWrongLength = "WFLYSEC0044: Salt has to be exactly 8 characters long.";
    protected String saltWrongLength$str() {
        return saltWrongLength;
    }
    @Override
    public final Exception saltWrongLength() {
        final Exception result = new Exception(String.format(getLoggingLocale(), saltWrongLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityVaultException = "WFLYSEC0045: Exception encountered:";
    protected String securityVaultException$str() {
        return securityVaultException;
    }
    @Override
    public final Exception securityVaultException(final SecurityVaultException cause) {
        final Exception result = new Exception(String.format(getLoggingLocale(), securityVaultException$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String vaultAliasNotSpecified = "WFLYSEC0046: Vault alias has to be specified.";
    protected String vaultAliasNotSpecified$str() {
        return vaultAliasNotSpecified;
    }
    @Override
    public final Exception vaultAliasNotSpecified() {
        final Exception result = new Exception(String.format(getLoggingLocale(), vaultAliasNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String vaultAttributeCreateDisplay = "WFLYSEC0047: Secured attribute value has been stored in Vault.\nPlease make note of the following:\n********************************************\nVault Block:%s\nAttribute Name:%s\nConfiguration should be done as follows:\n%s\n********************************************";
    protected String vaultAttributeCreateDisplay$str() {
        return vaultAttributeCreateDisplay;
    }
    @Override
    public final String vaultAttributeCreateDisplay(final String VaultBlock, final String attributeName, final String configurationString) {
        return String.format(getLoggingLocale(), vaultAttributeCreateDisplay$str(), VaultBlock, attributeName, configurationString);
    }
    private static final String vaultConfigurationTitle = "WFLYSEC0048: Vault Configuration commands in WildFly for CLI:";
    protected String vaultConfigurationTitle$str() {
        return vaultConfigurationTitle;
    }
    @Override
    public final String vaultConfigurationTitle() {
        return String.format(getLoggingLocale(), vaultConfigurationTitle$str());
    }
    private static final String noConsole = "WFLYSEC0049: No console.";
    protected String noConsole$str() {
        return noConsole;
    }
    @Override
    public final String noConsole() {
        return String.format(getLoggingLocale(), noConsole$str());
    }
    private static final String enterEncryptionDirectory = "Enter directory to store encrypted files:";
    protected String enterEncryptionDirectory$str() {
        return enterEncryptionDirectory;
    }
    @Override
    public final String enterEncryptionDirectory() {
        return String.format(getLoggingLocale(), enterEncryptionDirectory$str());
    }
    private static final String enterKeyStoreURL = "Enter Keystore URL:";
    protected String enterKeyStoreURL$str() {
        return enterKeyStoreURL;
    }
    @Override
    public final String enterKeyStoreURL() {
        return String.format(getLoggingLocale(), enterKeyStoreURL$str());
    }
    private static final String enterKeyStorePassword = "Enter Keystore password:";
    protected String enterKeyStorePassword$str() {
        return enterKeyStorePassword;
    }
    @Override
    public final String enterKeyStorePassword() {
        return String.format(getLoggingLocale(), enterKeyStorePassword$str());
    }
    private static final String enterSalt = "Enter 8 character salt:";
    protected String enterSalt$str() {
        return enterSalt;
    }
    @Override
    public final String enterSalt() {
        return String.format(getLoggingLocale(), enterSalt$str());
    }
    private static final String enterIterationCount = "Enter iteration count as a number (e.g.: 44):";
    protected String enterIterationCount$str() {
        return enterIterationCount;
    }
    @Override
    public final String enterIterationCount() {
        return String.format(getLoggingLocale(), enterIterationCount$str());
    }
    private static final String enterKeyStoreAlias = "Enter Keystore Alias:";
    protected String enterKeyStoreAlias$str() {
        return enterKeyStoreAlias;
    }
    @Override
    public final String enterKeyStoreAlias() {
        return String.format(getLoggingLocale(), enterKeyStoreAlias$str());
    }
    private static final String initializingVault = "WFLYSEC0056: Initializing Vault";
    protected String initializingVault$str() {
        return initializingVault;
    }
    @Override
    public final String initializingVault() {
        return String.format(getLoggingLocale(), initializingVault$str());
    }
    private static final String vaultInitialized = "WFLYSEC0057: Vault is initialized and ready for use";
    protected String vaultInitialized$str() {
        return vaultInitialized;
    }
    @Override
    public final String vaultInitialized() {
        return String.format(getLoggingLocale(), vaultInitialized$str());
    }
    private static final String handshakeComplete = "WFLYSEC0058: Handshake with Vault complete";
    protected String handshakeComplete$str() {
        return handshakeComplete;
    }
    @Override
    public final String handshakeComplete() {
        return String.format(getLoggingLocale(), handshakeComplete$str());
    }
    private static final String exceptionEncountered = "WFLYSEC0059: Exception encountered:";
    protected String exceptionEncountered$str() {
        return exceptionEncountered;
    }
    @Override
    public final String exceptionEncountered() {
        return String.format(getLoggingLocale(), exceptionEncountered$str());
    }
    private static final String enterYourPassword = "Enter your password:";
    protected String enterYourPassword$str() {
        return enterYourPassword;
    }
    @Override
    public final String enterYourPassword() {
        return String.format(getLoggingLocale(), enterYourPassword$str());
    }
    private static final String passwordAgain = "WFLYSEC0061:  again: ";
    protected String passwordAgain$str() {
        return passwordAgain;
    }
    @Override
    public final String passwordAgain() {
        return String.format(getLoggingLocale(), passwordAgain$str());
    }
    private static final String passwordsDoNotMatch = "Values entered don't match";
    protected String passwordsDoNotMatch$str() {
        return passwordsDoNotMatch;
    }
    @Override
    public final String passwordsDoNotMatch() {
        return String.format(getLoggingLocale(), passwordsDoNotMatch$str());
    }
    private static final String passwordsMatch = "Values match";
    protected String passwordsMatch$str() {
        return passwordsMatch;
    }
    @Override
    public final String passwordsMatch() {
        return String.format(getLoggingLocale(), passwordsMatch$str());
    }
    private static final String problemOcurred = "Problem occurred:";
    protected String problemOcurred$str() {
        return problemOcurred;
    }
    @Override
    public final String problemOcurred() {
        return String.format(getLoggingLocale(), problemOcurred$str());
    }
    private static final String interactiveCommandString = "Please enter a Digit::   0: Start Interactive Session   1: Remove Interactive Session  2: Exit";
    protected String interactiveCommandString$str() {
        return interactiveCommandString;
    }
    @Override
    public final String interactiveCommandString() {
        return String.format(getLoggingLocale(), interactiveCommandString$str());
    }
    private static final String startingInteractiveSession = "Starting an interactive session";
    protected String startingInteractiveSession$str() {
        return startingInteractiveSession;
    }
    @Override
    public final String startingInteractiveSession() {
        return String.format(getLoggingLocale(), startingInteractiveSession$str());
    }
    private static final String removingInteractiveSession = "Removing the current interactive session";
    protected String removingInteractiveSession$str() {
        return removingInteractiveSession;
    }
    @Override
    public final String removingInteractiveSession() {
        return String.format(getLoggingLocale(), removingInteractiveSession$str());
    }
    private static final String problemParsingCommandLineParameters = "WFLYSEC0068: Problem while parsing command line parameters:";
    protected String problemParsingCommandLineParameters$str() {
        return problemParsingCommandLineParameters;
    }
    @Override
    public final String problemParsingCommandLineParameters() {
        return String.format(getLoggingLocale(), problemParsingCommandLineParameters$str());
    }
    private static final String cmdLineKeyStoreURL = "Keystore URL";
    protected String cmdLineKeyStoreURL$str() {
        return cmdLineKeyStoreURL;
    }
    @Override
    public final String cmdLineKeyStoreURL() {
        return String.format(getLoggingLocale(), cmdLineKeyStoreURL$str());
    }
    private static final String cmdLineKeyStorePassword = "Keystore password";
    protected String cmdLineKeyStorePassword$str() {
        return cmdLineKeyStorePassword;
    }
    @Override
    public final String cmdLineKeyStorePassword() {
        return String.format(getLoggingLocale(), cmdLineKeyStorePassword$str());
    }
    private static final String cmdLineEncryptionDirectory = "Directory containing encrypted files";
    protected String cmdLineEncryptionDirectory$str() {
        return cmdLineEncryptionDirectory;
    }
    @Override
    public final String cmdLineEncryptionDirectory() {
        return String.format(getLoggingLocale(), cmdLineEncryptionDirectory$str());
    }
    private static final String cmdLineSalt = "8 character salt";
    protected String cmdLineSalt$str() {
        return cmdLineSalt;
    }
    @Override
    public final String cmdLineSalt() {
        return String.format(getLoggingLocale(), cmdLineSalt$str());
    }
    private static final String cmdLineIterationCount = "Iteration count";
    protected String cmdLineIterationCount$str() {
        return cmdLineIterationCount;
    }
    @Override
    public final String cmdLineIterationCount() {
        return String.format(getLoggingLocale(), cmdLineIterationCount$str());
    }
    private static final String cmdLineVaultKeyStoreAlias = "Vault keystore alias";
    protected String cmdLineVaultKeyStoreAlias$str() {
        return cmdLineVaultKeyStoreAlias;
    }
    @Override
    public final String cmdLineVaultKeyStoreAlias() {
        return String.format(getLoggingLocale(), cmdLineVaultKeyStoreAlias$str());
    }
    private static final String cmdLineVaultBlock = "Vault block";
    protected String cmdLineVaultBlock$str() {
        return cmdLineVaultBlock;
    }
    @Override
    public final String cmdLineVaultBlock() {
        return String.format(getLoggingLocale(), cmdLineVaultBlock$str());
    }
    private static final String cmdLineAttributeName = "Attribute name";
    protected String cmdLineAttributeName$str() {
        return cmdLineAttributeName;
    }
    @Override
    public final String cmdLineAttributeName() {
        return String.format(getLoggingLocale(), cmdLineAttributeName$str());
    }
    private static final String cmdLineSecuredAttribute = "Secured attribute value (such as password) to store";
    protected String cmdLineSecuredAttribute$str() {
        return cmdLineSecuredAttribute;
    }
    @Override
    public final String cmdLineSecuredAttribute() {
        return String.format(getLoggingLocale(), cmdLineSecuredAttribute$str());
    }
    private static final String cmdLineCheckAttribute = "Check whether the secured attribute already exists in the Vault";
    protected String cmdLineCheckAttribute$str() {
        return cmdLineCheckAttribute;
    }
    @Override
    public final String cmdLineCheckAttribute() {
        return String.format(getLoggingLocale(), cmdLineCheckAttribute$str());
    }
    private static final String cmdLineHelp = "Help";
    protected String cmdLineHelp$str() {
        return cmdLineHelp;
    }
    @Override
    public final String cmdLineHelp() {
        return String.format(getLoggingLocale(), cmdLineHelp$str());
    }
    private static final String cmdLineSecuredAttributeAlreadyExists = "WFLYSEC0080: Secured attribute (password) already exists.";
    protected String cmdLineSecuredAttributeAlreadyExists$str() {
        return cmdLineSecuredAttributeAlreadyExists;
    }
    @Override
    public final String cmdLineSecuredAttributeAlreadyExists() {
        return String.format(getLoggingLocale(), cmdLineSecuredAttributeAlreadyExists$str());
    }
    private static final String cmdLineSecuredAttributeDoesNotExist = "WFLYSEC0081: Secured attribute (password) doesn't exist.";
    protected String cmdLineSecuredAttributeDoesNotExist$str() {
        return cmdLineSecuredAttributeDoesNotExist;
    }
    @Override
    public final String cmdLineSecuredAttributeDoesNotExist() {
        return String.format(getLoggingLocale(), cmdLineSecuredAttributeDoesNotExist$str());
    }
    private static final String enterYourPasswordAgain = "Enter your password again:";
    protected String enterYourPasswordAgain$str() {
        return enterYourPasswordAgain;
    }
    @Override
    public final String enterYourPasswordAgain() {
        return String.format(getLoggingLocale(), enterYourPasswordAgain$str());
    }
    private static final String enterKeyStorePasswordAgain = "Enter Keystore password again:";
    protected String enterKeyStorePasswordAgain$str() {
        return enterKeyStorePasswordAgain;
    }
    @Override
    public final String enterKeyStorePasswordAgain() {
        return String.format(getLoggingLocale(), enterKeyStorePasswordAgain$str());
    }
    private static final String cmdLineRemoveSecuredAttribute = "Remove secured attribute from the Vault";
    protected String cmdLineRemoveSecuredAttribute$str() {
        return cmdLineRemoveSecuredAttribute;
    }
    @Override
    public final String cmdLineRemoveSecuredAttribute() {
        return String.format(getLoggingLocale(), cmdLineRemoveSecuredAttribute$str());
    }
    private static final String cmdLineAutomaticallyCreateKeystore = "Automatically create keystore when it doesn't exist";
    protected String cmdLineAutomaticallyCreateKeystore$str() {
        return cmdLineAutomaticallyCreateKeystore;
    }
    @Override
    public final String cmdLineAutomaticallyCreateKeystore() {
        return String.format(getLoggingLocale(), cmdLineAutomaticallyCreateKeystore$str());
    }
    private static final String messageAttributeRemovedSuccessfuly = "Secured attribute %s has been successfuly removed from vault";
    protected String messageAttributeRemovedSuccessfuly$str() {
        return messageAttributeRemovedSuccessfuly;
    }
    @Override
    public final String messageAttributeRemovedSuccessfuly(final String displayFormattedAttribute) {
        return String.format(getLoggingLocale(), messageAttributeRemovedSuccessfuly$str(), displayFormattedAttribute);
    }
    private static final String messageAttributeNotRemoved = "Secured attribute %s was not removed from vault, check whether it exist";
    protected String messageAttributeNotRemoved$str() {
        return messageAttributeNotRemoved;
    }
    @Override
    public final String messageAttributeNotRemoved(final String displayFormattedAttribute) {
        return String.format(getLoggingLocale(), messageAttributeNotRemoved$str(), displayFormattedAttribute);
    }
    private static final String interactionCommandOptions = "Please enter a Digit::  0: Store a secured attribute  1: Check whether a secured attribute exists  2: Remove secured attribute  3: Exit";
    protected String interactionCommandOptions$str() {
        return interactionCommandOptions;
    }
    @Override
    public final String interactionCommandOptions() {
        return String.format(getLoggingLocale(), interactionCommandOptions$str());
    }
    private static final String taskStoreSecuredAttribute = "Task: Store a secured attribute";
    protected String taskStoreSecuredAttribute$str() {
        return taskStoreSecuredAttribute;
    }
    @Override
    public final String taskStoreSecuredAttribute() {
        return String.format(getLoggingLocale(), taskStoreSecuredAttribute$str());
    }
    private static final String interactivePromptSecureAttributeValue = "Please enter secured attribute value (such as password)";
    protected String interactivePromptSecureAttributeValue$str() {
        return interactivePromptSecureAttributeValue;
    }
    @Override
    public final String interactivePromptSecureAttributeValue() {
        return String.format(getLoggingLocale(), interactivePromptSecureAttributeValue$str());
    }
    private static final String interactivePromptSecureAttributeValueAgain = "Please enter secured attribute value again";
    protected String interactivePromptSecureAttributeValueAgain$str() {
        return interactivePromptSecureAttributeValueAgain;
    }
    @Override
    public final String interactivePromptSecureAttributeValueAgain() {
        return String.format(getLoggingLocale(), interactivePromptSecureAttributeValueAgain$str());
    }
    private static final String interactivePromptVaultBlock = "Enter Vault Block:";
    protected String interactivePromptVaultBlock$str() {
        return interactivePromptVaultBlock;
    }
    @Override
    public final String interactivePromptVaultBlock() {
        return String.format(getLoggingLocale(), interactivePromptVaultBlock$str());
    }
    private static final String interactivePromptAttributeName = "Enter Attribute Name:";
    protected String interactivePromptAttributeName$str() {
        return interactivePromptAttributeName;
    }
    @Override
    public final String interactivePromptAttributeName() {
        return String.format(getLoggingLocale(), interactivePromptAttributeName$str());
    }
    private static final String taskVerifySecuredAttributeExists = "Task: Verify whether a secured attribute exists";
    protected String taskVerifySecuredAttributeExists$str() {
        return taskVerifySecuredAttributeExists;
    }
    @Override
    public final String taskVerifySecuredAttributeExists() {
        return String.format(getLoggingLocale(), taskVerifySecuredAttributeExists$str());
    }
    private static final String interactiveMessageNoValueStored = "No value has been stored for %s";
    protected String interactiveMessageNoValueStored$str() {
        return interactiveMessageNoValueStored;
    }
    @Override
    public final String interactiveMessageNoValueStored(final String displayFormattedAttribute) {
        return String.format(getLoggingLocale(), interactiveMessageNoValueStored$str(), displayFormattedAttribute);
    }
    private static final String interactiveMessageValueStored = "A value exists for %s";
    protected String interactiveMessageValueStored$str() {
        return interactiveMessageValueStored;
    }
    @Override
    public final String interactiveMessageValueStored(final String displayFormattedAttribute) {
        return String.format(getLoggingLocale(), interactiveMessageValueStored$str(), displayFormattedAttribute);
    }
    private static final String taskRemoveSecuredAttribute = "Task: Remove secured attribute";
    protected String taskRemoveSecuredAttribute$str() {
        return taskRemoveSecuredAttribute;
    }
    @Override
    public final String taskRemoveSecuredAttribute() {
        return String.format(getLoggingLocale(), taskRemoveSecuredAttribute$str());
    }
    private static final String actionNotSpecified = "Action not specified";
    protected String actionNotSpecified$str() {
        return actionNotSpecified;
    }
    @Override
    public final String actionNotSpecified() {
        return String.format(getLoggingLocale(), actionNotSpecified$str());
    }
    private static final String unableToLocateJSSEConfig = "WFLYSEC0100: Legacy security domain %s doesn't contain a valid JSSE configuration";
    protected String unableToLocateJSSEConfig$str() {
        return unableToLocateJSSEConfig;
    }
    @Override
    public final StartException unableToLocateJSSEConfig(final String legacyDomainName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToLocateJSSEConfig$str(), legacyDomainName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLocateComponentInJSSEDomain = "WFLYSEC0101: Unable to find a %s configuration in JSSE security domain %s";
    protected String unableToLocateComponentInJSSEDomain$str() {
        return unableToLocateComponentInJSSEDomain;
    }
    @Override
    public final StartException unableToLocateComponentInJSSEDomain(final String componentName, final String legacyDomainName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToLocateComponentInJSSEDomain$str(), componentName, legacyDomainName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedManagerTypeNotFound = "WFLYSEC0102: Could not find a %s of type %s in the JSSE security domain %s";
    protected String expectedManagerTypeNotFound$str() {
        return expectedManagerTypeNotFound;
    }
    @Override
    public final StartException expectedManagerTypeNotFound(final String managerName, final String managerType, final String legacyDomainName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), expectedManagerTypeNotFound$str(), managerName, managerType, legacyDomainName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateAuthorizationIdentity = "WFLYSEC0103: Unable to create AuthorizationIdentity: no authenticated Subject was found";
    protected String unableToCreateAuthorizationIdentity$str() {
        return unableToCreateAuthorizationIdentity;
    }
    @Override
    public final IllegalStateException unableToCreateAuthorizationIdentity() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToCreateAuthorizationIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void defaultCacheRequirementMissing(final String containerName, final String legacyCacheName) {
        super.log.logf(FQCN, WARN, null, defaultCacheRequirementMissing$str(), containerName, legacyCacheName);
    }
    private static final String defaultCacheRequirementMissing = "WFLYSEC0104: Default %s cache capability missing.  Assuming %s as default-cache.";
    protected String defaultCacheRequirementMissing$str() {
        return defaultCacheRequirementMissing;
    }
}
