/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyRemoveStepHandler;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.ComplexAttributes;
import org.jboss.as.security.SecurityExtension;
import org.jboss.dmr.ModelType;

public class JSSEResourceDefinition
extends SimpleResourceDefinition {
    static final ObjectTypeAttributeDefinition KEYSTORE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("keystore", (AttributeDefinition[])ComplexAttributes.KEY_STORE_FIELDS).setValidator((ParameterValidator)new ComplexAttributes.KeyStoreAttributeValidator("keystore"))).setAttributeMarshaller((AttributeMarshaller)new ComplexAttributes.KeyStoreAttributeMarshaller())).build();
    static final ObjectTypeAttributeDefinition TRUSTSTORE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("truststore", (AttributeDefinition[])ComplexAttributes.KEY_STORE_FIELDS).setValidator((ParameterValidator)new ComplexAttributes.KeyStoreAttributeValidator("truststore"))).setAttributeMarshaller((AttributeMarshaller)new ComplexAttributes.KeyStoreAttributeMarshaller())).build();
    static final ObjectTypeAttributeDefinition KEYMANAGER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("key-manager", (AttributeDefinition[])ComplexAttributes.KEY_MANAGER_FIELDS).setAttributeMarshaller((AttributeMarshaller)new ComplexAttributes.KeyManagerAttributeMarshaller())).build();
    static final ObjectTypeAttributeDefinition TRUSTMANAGER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("trust-manager", (AttributeDefinition[])ComplexAttributes.KEY_MANAGER_FIELDS).setAttributeMarshaller((AttributeMarshaller)new ComplexAttributes.KeyManagerAttributeMarshaller())).build();
    static final SimpleAttributeDefinition CLIENT_ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-alias", ModelType.STRING, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition SERVER_ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-alias", ModelType.STRING, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition SERVICE_AUTH_TOKEN = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("service-auth-token", ModelType.STRING, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition PROTOCOLS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocols", ModelType.STRING, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition CIPHER_SUITES = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suites", ModelType.STRING, true).setAllowExpression(true)).build();
    static final PropertiesAttributeDefinition ADDITIONAL_PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("additional-properties", true).setAllowExpression(true)).setAttributeMarshaller(AttributeMarshaller.PROPERTIES_MARSHALLER_UNWRAPPED)).setAttributeParser(AttributeParser.PROPERTIES_PARSER_UNWRAPPED)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{KEYSTORE, TRUSTSTORE, KEYMANAGER, TRUSTMANAGER, CLIENT_ALIAS, SERVER_ALIAS, SERVICE_AUTH_TOKEN, CLIENT_AUTH, PROTOCOLS, CIPHER_SUITES, ADDITIONAL_PROPERTIES};
    public static final JSSEResourceDefinition INSTANCE = new JSSEResourceDefinition();

    private JSSEResourceDefinition() {
        super(SecurityExtension.JSSE_PATH, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("jsse"), (OperationStepHandler)new ModelOnlyAddStepHandler(ATTRIBUTES), (OperationStepHandler)ModelOnlyRemoveStepHandler.INSTANCE);
        this.setDeprecated(SecurityExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ModelOnlyWriteAttributeHandler writeHandler = new ModelOnlyWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }
}

