/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.login;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialParameterCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.PeerPrincipalCallback;
import org.wildfly.security.auth.callback.RealmIdentityCallback;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.auth.login.SecurityDomain;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslServerFactory;

public final class ServerAuthenticationContext {
    private static final Map<String, String> QUERY_ALL = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");
    private final SecurityDomain domain;
    private boolean done = false;

    ServerAuthenticationContext(SecurityDomain domain) {
        this.domain = domain;
    }

    public SaslServer createSaslServer(SaslServerFactory saslServerFactory, String serverName, String mechanismName, String protocol) throws SaslException {
        if (this.done) {
            throw new SaslException("Authentication already performed");
        }
        return new AuthenticationCompleteCallbackSaslServerFactory(saslServerFactory).createSaslServer(mechanismName, protocol, serverName, QUERY_ALL, this.createCallbackHandler());
    }

    public SSLEngine createServerSslEngine() {
        throw new UnsupportedOperationException();
    }

    public SSLSocket createServerSslSocket() {
        throw new UnsupportedOperationException();
    }

    CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){
            RealmIdentity identity;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                try {
                    this.handleOne(callbacks, 0);
                }
                catch (RealmUnavailableException e) {
                    throw new IOException(e);
                }
            }

            private void handleOne(Callback[] callbacks, int idx) throws IOException, UnsupportedCallbackException, RealmUnavailableException {
                if (idx == callbacks.length) {
                    return;
                }
                Callback callback = callbacks[idx];
                if (callback instanceof NameCallback) {
                    if (this.identity != null) {
                        this.identity.dispose();
                        this.identity = null;
                    }
                    String name = ((NameCallback)callback).getName();
                    RealmIdentity realmIdentity = ServerAuthenticationContext.this.domain.mapName(name);
                    if (realmIdentity == null) {
                        throw new SaslException("Unknown user name");
                    }
                    this.identity = realmIdentity;
                    try {
                        this.handleOne(callbacks, idx + 1);
                    }
                    catch (Throwable t) {
                        this.identity = null;
                        throw t;
                    }
                }
                if (callback instanceof PeerPrincipalCallback) {
                    if (this.identity != null) {
                        throw new SaslException("Mechanism supplied multiple login names");
                    }
                    Principal principal = ((PeerPrincipalCallback)callback).getPrincipal();
                    RealmIdentity realmIdentity = ServerAuthenticationContext.this.domain.mapName(principal.getName());
                    if (realmIdentity == null) {
                        throw new SaslException("Unknown user name");
                    }
                    this.identity = realmIdentity;
                    try {
                        this.handleOne(callbacks, idx + 1);
                    }
                    catch (Throwable t) {
                        this.identity = null;
                        throw t;
                    }
                }
                if (callback instanceof PasswordCallback) {
                    block38: {
                        ClearPasswordSpec clearPasswordSpec;
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        RealmIdentity identity = this.identity;
                        if (identity == null) {
                            throw new SaslException("No user identity loaded for credential verification");
                        }
                        char[] providedPassword = passwordCallback.getPassword();
                        if (providedPassword != null) {
                            if (identity.getCredentialSupport(char[].class).isDefinitelyVerifiable() && !identity.verifyCredential(providedPassword)) {
                                throw new SaslException("Invalid password");
                            }
                            if (identity.getCredentialSupport(TwoWayPassword.class).isDefinitelyVerifiable()) {
                                try {
                                    PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
                                    Password password = passwordFactory.generatePassword(new ClearPasswordSpec(providedPassword));
                                    if (!identity.verifyCredential(password)) {
                                        throw new SaslException("Invalid password");
                                    }
                                    break block38;
                                }
                                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                                    throw new SaslException("Password verification not supported", e);
                                }
                            }
                            throw new SaslException("Password verification not supported");
                        }
                        TwoWayPassword credential = identity.getCredential(TwoWayPassword.class);
                        if (credential == null) {
                            throw new FastUnsupportedCallbackException(callback);
                        }
                        try {
                            PasswordFactory passwordFactory = PasswordFactory.getInstance(credential.getAlgorithm());
                            clearPasswordSpec = passwordFactory.getKeySpec(credential, ClearPasswordSpec.class);
                        }
                        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                            throw new FastUnsupportedCallbackException(callback);
                        }
                        passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof CredentialCallback) {
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    if (this.identity == null) {
                        throw new SaslException("No user identity loaded for credential verification");
                    }
                    for (Class<?> allowedType : credentialCallback.getAllowedTypes()) {
                        Object credential;
                        if (!this.identity.getCredentialSupport(allowedType).mayBeObtainable() || (credential = this.identity.getCredential(allowedType)) == null) continue;
                        credentialCallback.setCredential(credential);
                        break;
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof CredentialParameterCallback) {
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AnonymousAuthorizationCallback) {
                    ((AnonymousAuthorizationCallback)callback).setAuthorized(ServerAuthenticationContext.this.domain.isAnonymousAllowed());
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AuthenticationCompleteCallback) {
                    this.identity = null;
                    ServerAuthenticationContext.this.done = true;
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof SocketAddressCallback) {
                    SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                    if (socketAddressCallback.getKind() == SocketAddressCallback.Kind.PEER) {
                        // empty if block
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof RealmIdentityCallback) {
                    ((RealmIdentityCallback)callback).setRealmIdentity(this.identity);
                    this.handleOne(callbacks, idx + 1);
                } else {
                    CallbackUtil.unsupported(callback);
                }
            }
        };
    }
}

