/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.LdapSecurityRealm;
import org.wildfly.security.auth.provider.ldap.UserPasswordCredentialLoader;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.auth.util.NameRewriter;

public class LdapSecurityRealmBuilder {
    private boolean built = false;
    private DirContextFactory dirContextFactory;
    private List<NameRewriter> nameRewriters = new LinkedList<NameRewriter>();
    private LdapSecurityRealm.PrincipalMapping principalMapping;
    private List<CredentialLoader> credentialLoaders = new LinkedList<CredentialLoader>();

    private LdapSecurityRealmBuilder() {
    }

    public static LdapSecurityRealmBuilder builder() {
        return new LdapSecurityRealmBuilder();
    }

    public LdapSecurityRealmBuilder setDirContextFactory(DirContextFactory dirContextFactory) {
        this.assertNotBuilt();
        this.dirContextFactory = dirContextFactory;
        return this;
    }

    public LdapSecurityRealmBuilder addNameRewriter(NameRewriter nameReWriter) {
        this.assertNotBuilt();
        this.nameRewriters.add(nameReWriter);
        return this;
    }

    public PrincipalMappingBuilder principalMapping() {
        this.assertNotBuilt();
        return new PrincipalMappingBuilder();
    }

    public UserPasswordCredentialLoaderBuilder userPassword() {
        this.assertNotBuilt();
        return new UserPasswordCredentialLoaderBuilder();
    }

    public LdapSecurityRealm build() {
        this.assertNotBuilt();
        if (this.dirContextFactory == null) {
            throw new IllegalStateException("No DirContextFactory set.");
        }
        if (this.principalMapping == null) {
            throw new IllegalStateException("No principal mapping definition.");
        }
        this.built = true;
        return new LdapSecurityRealm(this.dirContextFactory, this.nameRewriters, this.principalMapping, this.credentialLoaders);
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("Builder has already been built.");
        }
    }

    public class UserPasswordCredentialLoaderBuilder {
        private boolean built = false;
        private String userPasswordAttributeName = "userPassword";
        private Map<Class<?>, CredentialSupport> credentialSupportMap = new HashMap();

        public UserPasswordCredentialLoaderBuilder setUserPasswordAttributeName(String userPasswordAttributeName) {
            this.assertNotBuilt();
            this.userPasswordAttributeName = userPasswordAttributeName;
            return this;
        }

        public UserPasswordCredentialLoaderBuilder addCredentialSupport(Class<?> credentialType, CredentialSupport support) {
            this.assertNotBuilt();
            this.credentialSupportMap.put(credentialType, support);
            return this;
        }

        public LdapSecurityRealmBuilder build() {
            this.assertNotBuilt();
            this.built = true;
            LdapSecurityRealmBuilder.this.credentialLoaders.add(new UserPasswordCredentialLoader(this.userPasswordAttributeName, this.credentialSupportMap));
            return LdapSecurityRealmBuilder.this;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("Builder has already been built.");
            }
            LdapSecurityRealmBuilder.this.assertNotBuilt();
        }
    }

    public class PrincipalMappingBuilder {
        private boolean built = false;
        private String searchDn = null;
        private boolean recursive = false;
        private boolean nameIsDn = false;
        private boolean principalUseDn = false;
        private String nameAttribute;
        private String dnAttribute;
        private boolean validatePresence;
        private boolean reloadPrincipalName = false;

        public PrincipalMappingBuilder setSearchDn(String searchDn) {
            this.assertNotBuilt();
            this.searchDn = searchDn;
            return this;
        }

        public PrincipalMappingBuilder setRecursive(boolean recursive) {
            this.assertNotBuilt();
            this.recursive = recursive;
            return this;
        }

        public PrincipalMappingBuilder setNameIsDn(boolean nameIsDn) {
            this.assertNotBuilt();
            this.nameIsDn = nameIsDn;
            return this;
        }

        public PrincipalMappingBuilder setPrincipalUseDn(boolean principalUseDn) {
            this.assertNotBuilt();
            this.principalUseDn = principalUseDn;
            return this;
        }

        public PrincipalMappingBuilder setNameAttribute(String nameAttribute) {
            this.assertNotBuilt();
            this.nameAttribute = nameAttribute;
            return this;
        }

        public PrincipalMappingBuilder setDnAttribute(String dnAttribute) {
            this.assertNotBuilt();
            this.dnAttribute = dnAttribute;
            return this;
        }

        public PrincipalMappingBuilder setValidatePresence(boolean validatePresence) {
            this.assertNotBuilt();
            this.validatePresence = validatePresence;
            return this;
        }

        public PrincipalMappingBuilder setReloadPrincipalName(boolean reloadPrincipalName) {
            this.assertNotBuilt();
            this.reloadPrincipalName = reloadPrincipalName;
            return this;
        }

        public LdapSecurityRealmBuilder build() {
            this.assertNotBuilt();
            LdapSecurityRealmBuilder.this.principalMapping = new LdapSecurityRealm.PrincipalMapping(this.searchDn, this.recursive, this.nameIsDn, this.principalUseDn, this.nameAttribute, this.dnAttribute, this.validatePresence, this.reloadPrincipalName);
            this.built = true;
            return LdapSecurityRealmBuilder.this;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("Builder has already been built.");
            }
            LdapSecurityRealmBuilder.this.assertNotBuilt();
        }
    }
}

