/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.spi;

public interface CredentialDecoder {
    public String getNameFromCredential(Object var1);

    public static CredentialDecoder aggregate(final CredentialDecoder ... decoders) {
        if (decoders == null) {
            throw new IllegalArgumentException("decoders is null");
        }
        return new CredentialDecoder(){

            @Override
            public String getNameFromCredential(Object credential) {
                for (CredentialDecoder decoder : decoders) {
                    String result = decoder.getNameFromCredential(credential);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        };
    }
}

