/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest.SaslQuote;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.util.ByteStringBuilder;

class DigestSaslServer
extends AbstractDigestMechanism
implements SaslServer {
    private final MessageDigest messageDigest;
    private static final byte STEP_ONE = 1;
    private static final byte STEP_THREE = 3;
    private String[] realms;
    private String supportedCiphers;
    private int receivingMaxBuffSize = 65536;
    private String[] qops;
    private int nonceCount = -1;

    DigestSaslServer(String[] realms, String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, Charset charset, String[] qops, String[] ciphers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.SERVER, charset, ciphers);
        this.realms = realms;
        this.supportedCiphers = DigestSaslServer.getSupportedCiphers(ciphers);
        this.qops = qops;
        try {
            this.messageDigest = MessageDigest.getInstance(DigestUtil.messageDigestAlgorithm(mechanismName));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(this.getMechanismName() + ": Expected message digest algorithm is not available", e);
        }
    }

    private byte[] generateChallenge() {
        ByteStringBuilder challenge = new ByteStringBuilder();
        StringBuilder sb = new StringBuilder();
        for (String realm : this.realms) {
            sb.append("realm=\"").append(SaslQuote.quote(realm)).append("\"").append(',');
        }
        challenge.append(sb.toString().getBytes(this.getCharset()));
        assert (this.nonce == null);
        this.nonce = DigestSaslServer.generateNonce();
        challenge.append("nonce=\"");
        challenge.append(SaslQuote.quote(this.nonce));
        challenge.append("\"").append(',');
        if (this.qops != null) {
            challenge.append("qop=\"");
            boolean first = true;
            for (String qop : this.qops) {
                if (!first) {
                    challenge.append(',');
                }
                first = false;
                challenge.append(SaslQuote.quote(qop));
            }
            challenge.append("\"").append(',');
        }
        if (this.receivingMaxBuffSize != 65536) {
            challenge.append("maxbuf=");
            challenge.append(String.valueOf(this.receivingMaxBuffSize));
            challenge.append(',');
        }
        if (StandardCharsets.UTF_8.equals(this.getCharset())) {
            challenge.append("charset=");
            challenge.append("utf-8");
            challenge.append(',');
        }
        if (this.supportedCiphers != null && this.qops != null && this.arrayContains(this.qops, "auth-conf")) {
            challenge.append("cipher=\"");
            challenge.append(this.supportedCiphers);
            challenge.append("\"").append(',');
        }
        challenge.append("algorithm=md5-sess");
        return challenge.toArray();
    }

    private void noteDigestResponseData(HashMap<String, byte[]> parsedDigestResponse) {
        byte[] data = parsedDigestResponse.get("nc");
        this.nonceCount = data != null ? Integer.parseInt(new String(data, StandardCharsets.UTF_8)) : -1;
        data = parsedDigestResponse.get("cipher");
        this.cipher = data != null ? new String(data, StandardCharsets.UTF_8) : "";
        data = parsedDigestResponse.get("authzid");
        this.authzid = data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    private byte[] validateDigestResponse(HashMap<String, byte[]> parsedDigestResponse) throws SaslException {
        byte[] digest_urp;
        if (this.nonceCount != 1) {
            throw new SaslException(this.getMechanismName() + ": nonce-count is not equal to 1");
        }
        Charset clientCharset = StandardCharsets.ISO_8859_1;
        if (parsedDigestResponse.get("charset") != null) {
            String cCharset = new String(parsedDigestResponse.get("charset"), StandardCharsets.UTF_8);
            if (StandardCharsets.UTF_8.equals(this.getCharset()) && cCharset.equals("utf-8")) {
                clientCharset = StandardCharsets.UTF_8;
            } else {
                throw new SaslException(this.getMechanismName() + ": client charset should not be specified as server is using iso 8859-1");
            }
        }
        if (parsedDigestResponse.get("username") == null) {
            throw new SaslException(this.getMechanismName() + ": missing username directive");
        }
        String userName = new String(parsedDigestResponse.get("username"), clientCharset);
        String clientRealm = parsedDigestResponse.get("realm") != null ? new String(parsedDigestResponse.get("realm"), clientCharset) : "";
        if (!this.arrayContains(this.realms, clientRealm)) {
            throw new SaslException(this.getMechanismName() + ": client sent realm not present at the server (" + clientRealm + ")");
        }
        if (parsedDigestResponse.get("nonce") == null) {
            throw new SaslException(this.getMechanismName() + ": missing nonce");
        }
        byte[] nonceFromClient = parsedDigestResponse.get("nonce");
        if (!Arrays.equals(this.nonce, nonceFromClient)) {
            throw new SaslException(this.getMechanismName() + ": nonce mismatch");
        }
        if (parsedDigestResponse.get("cnonce") == null) {
            throw new SaslException(this.getMechanismName() + ": missing cnonce");
        }
        this.cnonce = parsedDigestResponse.get("cnonce");
        if (parsedDigestResponse.get("nc") == null) {
            throw new SaslException(this.getMechanismName() + ": missing nonce-count");
        }
        if (parsedDigestResponse.get("digest-uri") != null) {
            String digest_uri = new String(parsedDigestResponse.get("digest-uri"), clientCharset);
            if (!digest_uri.equalsIgnoreCase(this.digestURI)) {
                throw new SaslException(this.getMechanismName() + ": mismatched digest-uri " + digest_uri + ". Expected: " + this.digestURI);
            }
        } else {
            throw new SaslException(this.getMechanismName() + ": digest-uri directive is missing");
        }
        this.qop = "auth";
        if (parsedDigestResponse.get("qop") != null) {
            this.qop = new String(parsedDigestResponse.get("qop"), clientCharset);
            if (!this.arrayContains(DigestUtil.QOP_VALUES, this.qop)) {
                throw new SaslException(this.getMechanismName() + ": qop directive unexpected value " + this.qop);
            }
            if (this.qop != null && !this.qop.equals("auth")) {
                this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this, this.qop.equals("auth-conf")));
            }
        }
        NameCallback nameCallback = new NameCallback("User name", userName);
        CredentialCallback credentialCallback = new CredentialCallback(DigestPassword.class);
        PasswordCallback passwordCallback = new PasswordCallback("User password", false);
        RealmCallback realmCallback = new RealmCallback("User realm");
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(userName, this.authzid == null ? userName : this.authzid);
        try {
            this.tryHandleCallbacks(realmCallback, nameCallback, authorizeCallback, credentialCallback);
            DigestPassword password = (DigestPassword)credentialCallback.getCredential();
            digest_urp = password.getDigest();
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == credentialCallback) {
                this.handleCallbacks(realmCallback, nameCallback, passwordCallback, authorizeCallback);
                char[] clearPassword = passwordCallback.getPassword();
                passwordCallback.clearPassword();
                digest_urp = DigestUtil.userRealmPasswordDigest(this.messageDigest, userName, clientRealm, clearPassword);
                if (clearPassword != null) {
                    Arrays.fill(clearPassword, '\u0000');
                }
            }
            throw new SaslException("Callback handler failed", e);
        }
        if (digest_urp == null) {
            throw new SaslException(this.getMechanismName() + ": authentication failed - null digest URP");
        }
        this.hA1 = DigestUtil.H_A1(this.messageDigest, digest_urp, this.nonce, this.cnonce, this.authzid, clientCharset);
        byte[] expectedResponse = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authzid, this.qop, this.digestURI, true);
        this.createCiphersAndKeys();
        if (parsedDigestResponse.get("response") != null) {
            if (Arrays.equals(expectedResponse, parsedDigestResponse.get("response"))) {
                if (!authorizeCallback.isAuthorized()) {
                    throw new SaslException(this.getMechanismName() + ": " + userName + " not authorized to act as " + this.authzid);
                }
                this.authzid = authorizeCallback.getAuthorizedID();
                return this.createResponseAuth(parsedDigestResponse);
            }
            throw new SaslException(this.getMechanismName() + ": authentication failed - bad response");
        }
        throw new SaslException(this.getMechanismName() + ": missing response directive");
    }

    private byte[] createResponseAuth(HashMap<String, byte[]> parsedDigestResponse) {
        ByteStringBuilder responseAuth = new ByteStringBuilder();
        responseAuth.append("rspauth=");
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authzid, this.qop, this.digestURI, false);
        responseAuth.append(response_value);
        return responseAuth.toArray();
    }

    @Override
    public String getAuthorizationID() {
        return this.authzid;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.evaluateMessage(response);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message.length != 0) {
                    throw new SaslException(this.getMechanismName() + ": When sending challenge message has to be empty.");
                }
                this.setNegotiationState(3);
                return this.generateChallenge();
            }
            case 3: {
                if (message == null || message.length == 0) {
                    throw new SaslException(this.getMechanismName() + ": message cannot be empty nor null");
                }
                HashMap<String, byte[]> parsedDigestResponse = this.parseResponse(message);
                this.noteDigestResponseData(parsedDigestResponse);
                byte[] response = this.validateDigestResponse(parsedDigestResponse);
                this.negotiationComplete();
                return response;
            }
        }
        throw new SaslException("Invalid state");
    }
}

