/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends AbstractAddStepHandler {
    public static final NativeManagementAddHandler INSTANCE = new NativeManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    public NativeManagementAddHandler() {
        super(NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName endpointName = ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostName, context.getServiceRegistry(false));
        NativeManagementAddHandler.installNativeManagementConnector(context, model, endpointName, serviceTarget);
    }

    static void installNativeManagementConnector(OperationContext context, ModelNode model, ServiceName endpointName, ServiceTarget serviceTarget) throws OperationFailedException {
        String bindingName = NativeManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        ServiceName socketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
        String securityRealm = null;
        ModelNode realmNode = NativeManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        if (realmNode.isDefined()) {
            securityRealm = realmNode.asString();
        } else {
            ServerLogger.ROOT_LOGGER.nativeManagementInterfaceIsUnsecured();
        }
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.server.temp.dir"});
        RemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"management", (String)securityRealm, null, (ServiceName)tmpDirPath);
        OptionMap options = NativeManagementAddHandler.createConnectorOptions(context, model);
        ManagementRemotingServices.installConnectorServicesForSocketBinding((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)"management", (ServiceName)socketBindingServiceName, (OptionMap)options);
    }

    private static OptionMap createConnectorOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)NativeManagementResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        ModelNode serverName = NativeManagementResourceDefinition.SERVER_NAME.resolveModelAttribute(context, model);
        if (serverName.isDefined()) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName.asString());
        }
        return builder.getMap();
    }
}

