/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.modules.Resource;

final class JarEntryResource
implements Resource {
    private final JarFile jarFile;
    private final JarEntry entry;
    private final URL resourceURL;

    JarEntryResource(JarFile jarFile, JarEntry entry, URL resourceURL) {
        this.jarFile = jarFile;
        this.entry = entry;
        this.resourceURL = resourceURL;
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public URL getURL() {
        return this.resourceURL;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.jarFile.getInputStream(this.entry);
    }

    @Override
    public long getSize() {
        long size = this.entry.getSize();
        return size == -1L ? 0L : size;
    }
}

