/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.AuthenticationConfiguration;
import org.wildfly.security.auth.AuthenticationContext;
import org.wildfly.security.auth.KeyStoreEntrySecurityFactory;
import org.wildfly.security.auth.MatchRule;
import org.wildfly.security.auth.RuleConfigurationPair;
import org.wildfly.security.auth.util.ElytronAuthenticator;
import org.wildfly.security.auth.util.NameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public final class ElytronXmlParser {
    private static final String NS_ELYTRON_1_0 = "urn:elytron:1.0";

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration() throws ConfigXMLParseException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_ELYTRON_1_0));){
                SecurityFactory<AuthenticationContext> securityFactory = ElytronXmlParser.parseAuthenticationClientConfiguration(streamReader);
                return securityFactory;
            }
        }
        return new FixedSecurityFactory<AuthenticationContext>(AuthenticationContext.EMPTY);
    }

    static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        block21: while (reader.hasNext()) {
            switch (reader.next()) {
                case 3: 
                case 5: {
                    continue block21;
                }
                case 7: {
                    continue block21;
                }
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:elytron:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "authentication-client": {
                            SecurityFactory<AuthenticationContext> futureContext = ElytronXmlParser.parseAuthenticationClientType(reader);
                            block22: while (reader.hasNext()) {
                                switch (reader.next()) {
                                    case 3: 
                                    case 5: {
                                        continue block22;
                                    }
                                    case 8: {
                                        return futureContext;
                                    }
                                }
                                if (reader.isWhiteSpace()) continue;
                                throw reader.unexpectedElement();
                            }
                            return futureContext;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
            if (reader.isWhiteSpace()) continue;
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        SecurityFactory<AuthenticationContext> futureContext = null;
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        boolean rules = false;
        boolean keyStores = false;
        boolean netAuthenticator = false;
        HashMap<String, SecurityFactory<KeyStore>> keyStoresMap = new HashMap<String, SecurityFactory<KeyStore>>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "rules": {
                        if (rules) {
                            throw reader.unexpectedElement();
                        }
                        rules = true;
                        futureContext = ElytronXmlParser.parseAuthenticationClientRulesType(reader, keyStoresMap);
                        break;
                    }
                    case "key-stores": {
                        if (keyStores) {
                            throw reader.unexpectedElement();
                        }
                        keyStores = true;
                        ElytronXmlParser.parseKeyStoresType(reader, keyStoresMap);
                        break;
                    }
                    case "net-authenticator": {
                        if (netAuthenticator) {
                            throw reader.unexpectedElement();
                        }
                        netAuthenticator = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (netAuthenticator) {
                    Authenticator.setDefault(new ElytronAuthenticator());
                }
                return futureContext == null ? new FixedSecurityFactory<AuthenticationContext>(AuthenticationContext.EMPTY) : futureContext;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientRulesType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        HashMap<String, SecurityFactory<RuleConfigurationPair>> rulesMap = new HashMap<String, SecurityFactory<RuleConfigurationPair>>();
        final ArrayList<SecurityFactory<RuleConfigurationPair>> rulesList = new ArrayList<SecurityFactory<RuleConfigurationPair>>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "rule": {
                        ElytronXmlParser.parseAuthenticationClientRuleType(reader, rulesList, rulesMap, keyStoresMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return new OneTimeSecurityFactory<AuthenticationContext>(new SecurityFactory<AuthenticationContext>(){

                    @Override
                    public AuthenticationContext create() throws GeneralSecurityException {
                        AuthenticationContext context = AuthenticationContext.EMPTY;
                        for (SecurityFactory pairFactory : rulesList) {
                            RuleConfigurationPair pair = (RuleConfigurationPair)pairFactory.create();
                            context = context.with(pair.getMatchRule(), pair.getConfiguration());
                        }
                        return context;
                    }
                });
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static void parseAuthenticationClientRuleType(ConfigurationXMLStreamReader reader, List<SecurityFactory<RuleConfigurationPair>> rulesList, final Map<String, SecurityFactory<RuleConfigurationPair>> rulesMap, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        SecurityFactory<AuthenticationConfiguration> configuration;
        SecurityFactory<MatchRule> rule;
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String _extends = null;
        block50: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "extends": {
                    if (_extends != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    _extends = reader.getAttributeValue(i);
                    continue block50;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValue(i);
                    continue block50;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (_extends == null) {
            rule = new FixedSecurityFactory<MatchRule>(MatchRule.ALL);
            configuration = new FixedSecurityFactory<AuthenticationConfiguration>(AuthenticationConfiguration.EMPTY);
        } else {
            final String ext = _extends;
            rule = new SecurityFactory<MatchRule>(){

                @Override
                public MatchRule create() throws GeneralSecurityException {
                    SecurityFactory factory = (SecurityFactory)rulesMap.get(ext);
                    if (factory == null) {
                        throw new IllegalArgumentException("Missing reference in extends");
                    }
                    return ((RuleConfigurationPair)factory.create()).getMatchRule();
                }
            };
            configuration = new SecurityFactory<AuthenticationConfiguration>(){

                @Override
                public AuthenticationConfiguration create() throws GeneralSecurityException {
                    SecurityFactory factory = (SecurityFactory)rulesMap.get(ext);
                    if (factory == null) {
                        throw new IllegalArgumentException("Missing reference in extends");
                    }
                    return ((RuleConfigurationPair)factory.create()).getConfiguration();
                }
            };
        }
        boolean gotConfig = false;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "match-no-userinfo": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        ElytronXmlParser.parseEmptyType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchNoUser();
                            }
                        };
                        break;
                    }
                    case "match-userinfo": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final String userName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchUser(userName);
                            }
                        };
                        break;
                    }
                    case "match-protocol": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final String protoName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchProtocol(protoName);
                            }
                        };
                        break;
                    }
                    case "match-host": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final String hostName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchHost(hostName);
                            }
                        };
                        break;
                    }
                    case "match-path": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final String pathName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchPath(pathName);
                            }
                        };
                        break;
                    }
                    case "match-port": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final int port = ElytronXmlParser.parsePortType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchPort(port);
                            }
                        };
                        break;
                    }
                    case "match-urn": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final String urnString = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchUrnName(urnString);
                            }
                        };
                        break;
                    }
                    case "match-domain": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        final String domainName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<MatchRule> parentRule = rule;
                        rule = new SecurityFactory<MatchRule>(){

                            @Override
                            public MatchRule create() throws GeneralSecurityException {
                                return ((MatchRule)parentRule.create()).matchLocalSecurityDomain(domainName);
                            }
                        };
                        break;
                    }
                    case "set-host": {
                        gotConfig = true;
                        final String hostName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).useHost(hostName);
                            }
                        };
                        break;
                    }
                    case "set-port": {
                        gotConfig = true;
                        final int port = ElytronXmlParser.parsePortType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).usePort(port);
                            }
                        };
                        break;
                    }
                    case "set-user-name": {
                        gotConfig = true;
                        final String userName = ElytronXmlParser.parseNameType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).useName(userName);
                            }
                        };
                        break;
                    }
                    case "set-anonymous": {
                        gotConfig = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).useAnonymous();
                            }
                        };
                        break;
                    }
                    case "rewrite-user-name-regex": {
                        gotConfig = true;
                        final NameRewriter nameRewriter = ElytronXmlParser.parseRegexSubstitutionType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).rewriteUser(nameRewriter);
                            }
                        };
                        break;
                    }
                    case "require-sasl-mechanisms": {
                        gotConfig = true;
                        final String[] names = ElytronXmlParser.parseNamesType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).allowSaslMechanisms(names);
                            }
                        };
                        break;
                    }
                    case "forbid-sasl-mechanisms": {
                        gotConfig = true;
                        final String[] names = ElytronXmlParser.parseNamesType(reader);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).forbidSaslMechanisms(names);
                            }
                        };
                        break;
                    }
                    case "key-store-credential": {
                        gotConfig = true;
                        final SecurityFactory<KeyStore.Entry> factory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        final SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = new SecurityFactory<AuthenticationConfiguration>(){

                            @Override
                            public AuthenticationConfiguration create() throws GeneralSecurityException {
                                return ((AuthenticationConfiguration)parentConfig.create()).useKeyStoreCredential((KeyStore.Entry)factory.create());
                            }
                        };
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                final OneTimeSecurityFactory<MatchRule> finalRule = new OneTimeSecurityFactory<MatchRule>(rule);
                final OneTimeSecurityFactory<AuthenticationConfiguration> finalConfig = new OneTimeSecurityFactory<AuthenticationConfiguration>(configuration);
                SecurityFactory<RuleConfigurationPair> finalPair = new SecurityFactory<RuleConfigurationPair>(){

                    @Override
                    public RuleConfigurationPair create() throws GeneralSecurityException {
                        return new RuleConfigurationPair((MatchRule)finalRule.create(), (AuthenticationConfiguration)finalConfig.create());
                    }
                };
                rulesList.add(finalPair);
                if (name != null) {
                    rulesMap.put(name, finalPair);
                }
                return;
            }
            throw reader.unexpectedContent();
        }
    }

    public static void parseKeyStoresType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "key-store": {
                        ElytronXmlParser.parseKeyStoreType(reader, keyStoresMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static void parseKeyStoreType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String type = null;
        String provider = null;
        block28: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    if (type != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    type = reader.getAttributeValue(i);
                    continue block28;
                }
                case "provider": {
                    if (provider != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    provider = reader.getAttributeValue(i);
                    continue block28;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValue(i);
                    continue block28;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (type == null) {
            throw ElytronXmlParser.missingAttribute(reader, "type");
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        OneTimeSecurityFactory<char[]> passwordFactory = null;
        boolean gotSource = false;
        boolean gotCredential = false;
        String fileSource = null;
        String resourceSource = null;
        URI uriSource = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (!gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        final SecurityFactory<KeyStore.Entry> entryFactory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        passwordFactory = new OneTimeSecurityFactory<char[]>(new SecurityFactory<char[]>(){

                            @Override
                            public char[] create() throws GeneralSecurityException {
                                KeyStore.Entry entry = (KeyStore.Entry)entryFactory.create();
                                if (entry instanceof PasswordEntry) {
                                    Password password = ((PasswordEntry)entry).getPassword();
                                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                                    ClearPasswordSpec passwordSpec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                                    return passwordSpec.getEncodedPassword();
                                }
                                return null;
                            }
                        });
                        break;
                    }
                    case "file": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        fileSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "resource": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        resourceSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "uri": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        uriSource = ElytronXmlParser.parseUriType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (fileSource != null) {
                    keyStoresMap.put(name, new OneTimeSecurityFactory<KeyStore>(new FileKeyStoreFactory(provider, type, passwordFactory, fileSource)));
                } else if (resourceSource != null) {
                    keyStoresMap.put(name, new OneTimeSecurityFactory<KeyStore>(new ResourceKeyStoreFactory(provider, type, passwordFactory, resourceSource)));
                } else if (uriSource != null) {
                    keyStoresMap.put(name, new OneTimeSecurityFactory<KeyStore>(new URIKeyStoreFactory(provider, type, passwordFactory, uriSource)));
                } else {
                    throw new IllegalStateException();
                }
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static SecurityFactory<KeyStore.Entry> parseKeyStoreRefType(ConfigurationXMLStreamReader reader, final Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String keyStoreName = null;
        String alias = null;
        block20: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "key-store-name": {
                    if (keyStoreName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    keyStoreName = reader.getAttributeValue(i);
                    continue block20;
                }
                case "alias": {
                    if (alias != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    alias = reader.getAttributeValue(i);
                    continue block20;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (keyStoreName == null) {
            throw ElytronXmlParser.missingAttribute(reader, "key-store-name");
        }
        if (alias == null) {
            throw ElytronXmlParser.missingAttribute(reader, "alias");
        }
        SecurityFactory<KeyStore.Entry> keyStoreCredential = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        keyStoreCredential = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                final SecurityFactory<KeyStore.Entry> finalKeyStoreCredential = keyStoreCredential;
                final String finalKeyStoreName = keyStoreName;
                return new KeyStoreEntrySecurityFactory(new SecurityFactory<KeyStore>(){

                    @Override
                    public KeyStore create() throws GeneralSecurityException {
                        SecurityFactory keyStoreSecurityFactory = (SecurityFactory)keyStoresMap.get(finalKeyStoreName);
                        if (keyStoreSecurityFactory == null) {
                            throw new IllegalArgumentException("Unknown key store specified");
                        }
                        return (KeyStore)keyStoreSecurityFactory.create();
                    }
                }, alias, keyStoreCredential == null ? null : new SecurityFactory<KeyStore.ProtectionParameter>(){

                    @Override
                    public KeyStore.ProtectionParameter create() throws GeneralSecurityException {
                        KeyStore.Entry entry = (KeyStore.Entry)finalKeyStoreCredential.create();
                        if (entry instanceof PasswordEntry) {
                            Password password = ((PasswordEntry)entry).getPassword();
                            PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                            ClearPasswordSpec spec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                            return new KeyStore.PasswordProtection(spec.getEncodedPassword());
                        }
                        if (entry instanceof KeyStore.SecretKeyEntry) {
                            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                            SecretKeyFactory instance = SecretKeyFactory.getInstance(secretKey.getAlgorithm());
                            SecretKeySpec keySpec = (SecretKeySpec)instance.getKeySpec(secretKey, SecretKeySpec.class);
                            byte[] encoded = keySpec.getEncoded();
                            return encoded == null ? null : new KeyStore.PasswordProtection(new String(encoded, StandardCharsets.UTF_8).toCharArray());
                        }
                        return null;
                    }
                });
            }
            throw reader.unexpectedContent();
        }
        return null;
    }

    public static void parseEmptyType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static String parseNameType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("name")) {
                throw reader.unexpectedAttribute(i);
            }
            name = reader.getAttributeValue(i);
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return name;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static int parsePortType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        int number = -1;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (reader.getAttributeLocalName(i).equals("number")) {
                String s = reader.getAttributeValue(i);
                try {
                    number = Integer.parseInt(s);
                }
                catch (NumberFormatException ignored) {
                    throw ElytronXmlParser.invalidPortNumber(reader, i);
                }
                if (number >= 1 && number <= 65535) continue;
                throw ElytronXmlParser.invalidPortNumber(reader, i);
            }
            throw reader.unexpectedAttribute(i);
        }
        if (number == -1) {
            throw ElytronXmlParser.missingAttribute(reader, "number");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return number;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static NameRewriter parseRegexSubstitutionType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Pattern pattern = null;
        String replacement = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (reader.getAttributeLocalName(i).equals("pattern")) {
                pattern = Pattern.compile(reader.getAttributeValue(i));
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("replacement")) {
                replacement = reader.getAttributeValue(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (pattern == null) {
            throw ElytronXmlParser.missingAttribute(reader, "pattern");
        }
        if (replacement == null) {
            throw ElytronXmlParser.missingAttribute(reader, "replacement");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return new RegexNameRewriter(pattern, replacement, true);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static String[] parseNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String[] names = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("names")) {
                throw reader.unexpectedAttribute(i);
            }
            String s = reader.getAttributeValue(i);
            names = s.trim().split("\\s+");
        }
        if (names == null) {
            throw ElytronXmlParser.missingAttribute(reader, "names");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return names;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static URI parseUriType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        URI uri = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("uri")) {
                throw reader.unexpectedAttribute(i);
            }
            uri = reader.getURIAttributeValue(i);
        }
        if (uri == null) {
            throw ElytronXmlParser.missingAttribute(reader, "uri");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return uri;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static ConfigXMLParseException missingAttribute(ConfigurationXMLStreamReader reader, String name) {
        return reader.missingRequiredAttribute(null, name);
    }

    private static ConfigXMLParseException invalidPortNumber(ConfigurationXMLStreamReader reader, int index) {
        return ElytronMessages.xmlLog.xmlInvalidPortNumber((XMLStreamReader)reader, reader.getAttributeValue(index), reader.getAttributeLocalName(index), reader.getName());
    }

    static final class URIKeyStoreFactory
    extends AbstractKeyStoreFactory {
        private final URI uri;

        URIKeyStoreFactory(String provider, String type, SecurityFactory<char[]> passwordFactory, URI uri) {
            super(provider, type, passwordFactory);
            this.uri = uri;
        }

        @Override
        InputStream createStream() throws IOException {
            return this.uri.toURL().openStream();
        }
    }

    static final class ResourceKeyStoreFactory
    extends AbstractKeyStoreFactory {
        private final String resourceName;

        ResourceKeyStoreFactory(String provider, String type, SecurityFactory<char[]> passwordFactory, String resourceName) {
            super(provider, type, passwordFactory);
            this.resourceName = resourceName;
        }

        @Override
        InputStream createStream() throws IOException {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream stream = contextClassLoader.getResourceAsStream(this.resourceName);
            if (stream == null) {
                throw new FileNotFoundException(this.resourceName);
            }
            return stream;
        }
    }

    static final class FileKeyStoreFactory
    extends AbstractKeyStoreFactory {
        private final String fileName;

        FileKeyStoreFactory(String provider, String type, SecurityFactory<char[]> passwordFactory, String fileName) {
            super(provider, type, passwordFactory);
            this.fileName = fileName;
        }

        @Override
        InputStream createStream() throws FileNotFoundException {
            return new FileInputStream(this.fileName);
        }
    }

    static abstract class AbstractKeyStoreFactory
    implements SecurityFactory<KeyStore> {
        protected final String provider;
        protected final String type;
        protected final SecurityFactory<char[]> passwordFactory;

        AbstractKeyStoreFactory(String provider, String type, SecurityFactory<char[]> passwordFactory) {
            this.provider = provider;
            this.passwordFactory = passwordFactory;
            this.type = type;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            KeyStore keyStore = this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
            try (InputStream fis = this.createStream();){
                keyStore.load(fis, this.passwordFactory.create());
            }
            catch (IOException e) {
                throw new KeyStoreException("Failed to load keystore data", e);
            }
            return keyStore;
        }

        abstract InputStream createStream() throws IOException;
    }
}

