/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.localuser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.util.CodePointIterator;
import org.wildfly.security.util._private.Arrays2;

public final class LocalUserServer
extends AbstractSaslServer
implements SaslServer {
    public static final String LOCAL_USER_USE_SECURE_RANDOM = "wildfly.sasl.local-user.use-secure-random";
    public static final String LEGACY_LOCAL_USER_USE_SECURE_RANDOM = "jboss.sasl.local-user.use-secure-random";
    public static final String LOCAL_USER_CHALLENGE_PATH = "wildfly.sasl.local-user.challenge-path";
    public static final String LEGACY_LOCAL_USER_CHALLENGE_PATH = "jboss.sasl.local-user.challenge-path";
    public static final String DEFAULT_USER = "wildfly.sasl.local-user.default-user";
    public static final String LEGACY_DEFAULT_USER = "jboss.sasl.local-user.default-user";
    private static final byte UTF8NUL = 0;
    private static final int INITIAL_CHALLENGE_STATE = 1;
    private static final int PROCESS_RESPONSE_STATE = 2;
    private volatile String authorizationId;
    private volatile File challengeFile;
    private volatile byte[] challengeBytes;
    private final File basePath;
    private final String defaultUser;
    private final boolean useSecureRandom;

    LocalUserServer(String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) {
        super("JBOSS-LOCAL-USER", protocol, serverName, callbackHandler);
        String value;
        this.basePath = props.containsKey(LOCAL_USER_CHALLENGE_PATH) ? new File(props.get(LOCAL_USER_CHALLENGE_PATH).toString()).getAbsoluteFile() : (props.containsKey(LEGACY_LOCAL_USER_CHALLENGE_PATH) ? new File(props.get(LEGACY_LOCAL_USER_CHALLENGE_PATH).toString()).getAbsoluteFile() : ((value = LocalUserServer.getProperty(LOCAL_USER_CHALLENGE_PATH)) != null ? new File(value).getAbsoluteFile() : ((value = LocalUserServer.getProperty(LEGACY_LOCAL_USER_CHALLENGE_PATH)) != null ? new File(value).getAbsoluteFile() : new File(LocalUserServer.getProperty("java.io.tmpdir")))));
        String useSecureRandomObj = null;
        if (props.containsKey(LOCAL_USER_USE_SECURE_RANDOM)) {
            useSecureRandomObj = (String)props.get(LOCAL_USER_USE_SECURE_RANDOM);
        } else if (props.containsKey(LEGACY_LOCAL_USER_USE_SECURE_RANDOM)) {
            useSecureRandomObj = props.get(LEGACY_LOCAL_USER_USE_SECURE_RANDOM);
        } else {
            useSecureRandomObj = LocalUserServer.getProperty(LOCAL_USER_USE_SECURE_RANDOM);
            if (useSecureRandomObj == null) {
                useSecureRandomObj = LocalUserServer.getProperty(LEGACY_LOCAL_USER_USE_SECURE_RANDOM);
            }
        }
        this.useSecureRandom = useSecureRandomObj != null ? (useSecureRandomObj instanceof Boolean ? (Boolean)((Object)useSecureRandomObj) : (useSecureRandomObj instanceof String ? Boolean.parseBoolean(useSecureRandomObj) : true)) : true;
        this.defaultUser = props.containsKey(DEFAULT_USER) ? (String)props.get(DEFAULT_USER) : (props.containsKey(LEGACY_DEFAULT_USER) ? (String)props.get(LEGACY_DEFAULT_USER) : null);
    }

    private static String getProperty(String name) {
        return WildFlySecurityManager.getPropertyPrivileged(name, null);
    }

    private Random getRandom() {
        if (this.useSecureRandom) {
            return new SecureRandom();
        }
        return new Random();
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        this.assertComplete();
        return this.authorizationId;
    }

    private void deleteChallenge() {
        if (this.challengeFile != null) {
            this.challengeFile.delete();
            this.challengeFile = null;
        }
    }

    @Override
    public void dispose() throws SaslException {
        super.dispose();
        this.deleteChallenge();
    }

    protected void finalize() throws Throwable {
        this.deleteChallenge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                byte[] bytes;
                FileOutputStream fos;
                if (message.length == 0) {
                    return NO_BYTES;
                }
                this.authorizationId = message.length == 1 && message[0] == 0 ? null : new String(message, StandardCharsets.UTF_8);
                Random random = this.getRandom();
                try {
                    this.challengeFile = File.createTempFile("local", ".challenge", this.basePath);
                }
                catch (IOException e) {
                    throw new SaslException("Failed to create challenge file", e);
                }
                try {
                    fos = new FileOutputStream(this.challengeFile);
                }
                catch (FileNotFoundException e) {
                    throw new SaslException("Failed to create challenge file", e);
                }
                boolean ok = false;
                try {
                    bytes = new byte[8];
                    random.nextBytes(bytes);
                    try {
                        fos.write(bytes);
                        fos.close();
                        ok = true;
                    }
                    catch (IOException e) {
                        throw new SaslException("Failed to create challenge file", e);
                    }
                }
                finally {
                    if (!ok) {
                        this.deleteChallenge();
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable e) {}
                }
                this.challengeBytes = bytes;
                String path = this.challengeFile.getAbsolutePath();
                byte[] response = CodePointIterator.ofString(path).asUtf8(true).drain();
                this.setNegotiationState(2);
                return response;
            }
            case 2: {
                String authenticationRealm;
                String authenticationId;
                this.deleteChallenge();
                int length = message.length;
                if (length < 8) {
                    throw new SaslException("Invalid response");
                }
                if (!Arrays.equals(this.challengeBytes, Arrays.copyOf(message, 8))) {
                    throw new SaslException("Invalid response");
                }
                int firstMarker = Arrays2.indexOf(message, 0, 8);
                if (firstMarker > -1) {
                    authenticationId = new String(message, 8, firstMarker - 8, StandardCharsets.UTF_8);
                    int secondMarker = Arrays2.indexOf(message, 0, firstMarker + 1);
                    authenticationRealm = secondMarker > -1 ? new String(message, firstMarker + 1, secondMarker - firstMarker - 1, StandardCharsets.UTF_8) : null;
                } else {
                    authenticationId = null;
                    authenticationRealm = null;
                }
                if (authenticationId == null || authenticationId.length() == 0) {
                    authenticationId = this.defaultUser;
                }
                if (authenticationId == null) {
                    throw new SaslException("No authentication ID given");
                }
                if (this.authorizationId == null) {
                    this.authorizationId = authenticationId;
                }
                NameCallback nameCallback = new NameCallback("User name", authenticationId);
                AuthorizeCallback authorizeCallback = new AuthorizeCallback(authenticationId, this.authorizationId);
                if (authenticationRealm == null) {
                    this.handleCallbacks(nameCallback, authorizeCallback);
                } else {
                    RealmCallback realmCallback = new RealmCallback("User realm", authenticationRealm);
                    this.handleCallbacks(realmCallback, nameCallback, authorizeCallback);
                }
                if (!authorizeCallback.isAuthorized()) {
                    throw new SaslException("User " + this.authorizationId + " is not authorized");
                }
                this.negotiationComplete();
                return null;
            }
        }
        throw new SaslException("Invalid state");
    }
}

