/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.jboss.as.controller.client.helpers.domain.UpdateFailedException;
import org.jboss.as.controller.client.helpers.domain.impl.BasicDomainUpdateResult;
import org.jboss.as.controller.client.helpers.domain.impl.ServerGroupDeploymentActionResultImpl;

class DeploymentActionResultImpl
implements DeploymentActionResult {
    private final DeploymentAction deploymentAction;
    private final BasicDomainUpdateResult applierResponse;
    private final Map<String, ServerGroupDeploymentActionResult> serverResults = new HashMap<String, ServerGroupDeploymentActionResult>();
    private BasicDomainUpdateResult rollbackResponse;

    DeploymentActionResultImpl(DeploymentAction deploymentAction, BasicDomainUpdateResult applierResponse) {
        assert (deploymentAction != null) : "deploymentAction is null";
        assert (applierResponse != null) : "applierResponse is null";
        this.deploymentAction = deploymentAction;
        this.applierResponse = applierResponse;
    }

    @Override
    public DeploymentAction getDeploymentAction() {
        return this.deploymentAction;
    }

    @Override
    public UUID getDeploymentActionId() {
        return this.deploymentAction.getId();
    }

    @Override
    public UpdateFailedException getDomainControllerFailure() {
        return this.applierResponse.getDomainFailure();
    }

    @Override
    public Map<String, ServerGroupDeploymentActionResult> getResultsByServerGroup() {
        return Collections.unmodifiableMap(this.serverResults);
    }

    @Override
    public Map<String, UpdateFailedException> getHostControllerFailures() {
        return this.applierResponse.getHostFailures();
    }

    @Override
    public boolean isCancelledByDomain() {
        return this.applierResponse.isCancelled();
    }

    @Override
    public boolean isRolledBackOnDomain() {
        return this.rollbackResponse != null ? true : this.applierResponse.isRolledBack();
    }

    @Override
    public UpdateFailedException getDomainControllerRollbackFailure() {
        return this.rollbackResponse == null ? null : this.rollbackResponse.getDomainFailure();
    }

    @Override
    public Map<String, UpdateFailedException> getHostControllerRollbackFailures() {
        return this.rollbackResponse == null ? Collections.emptyMap() : this.rollbackResponse.getHostFailures();
    }

    void markRolledBack(BasicDomainUpdateResult rollbackResponse) {
        this.rollbackResponse = rollbackResponse;
    }

    void storeServerUpdateResult(ServerIdentity server, ServerUpdateResult result) {
        ServerGroupDeploymentActionResultImpl sgdar = (ServerGroupDeploymentActionResultImpl)this.serverResults.get(server.getServerGroupName());
        if (sgdar == null) {
            sgdar = new ServerGroupDeploymentActionResultImpl(server.getServerGroupName());
            this.serverResults.put(server.getServerGroupName(), sgdar);
        }
        sgdar.storeServerResult(server.getServerName(), result);
    }
}

