/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.nio.ByteBuffer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class ServletContainerService
implements Service<ServletContainerService> {
    private final boolean allowNonStandardWrappers;
    private final ServletStackTraces stackTraces;
    private final SessionCookieConfig sessionCookieConfig;
    private final JSPConfig jspConfig;
    private volatile ServletContainer servletContainer;
    private final InjectedValue<DirectBufferCache> bufferCacheInjectedValue = new InjectedValue();
    private final InjectedValue<SessionPersistenceManager> sessionPersistenceManagerInjectedValue = new InjectedValue();
    private final String defaultEncoding;
    private final boolean useListenerEncoding;
    private final boolean ignoreFlush;
    private final boolean eagerFilterInit;
    private final int defaultSessionTimeout;
    private final boolean disableCachingForSecuredPages;
    private final boolean websocketsEnabled;
    private final InjectedValue<Pool<ByteBuffer>> websocketsBufferPool = new InjectedValue();
    private final InjectedValue<XnioWorker> websocketsWorker = new InjectedValue();
    private final boolean dispatchWebsocketInvocationToWorker;

    public ServletContainerService(boolean allowNonStandardWrappers, ServletStackTraces stackTraces, SessionCookieConfig sessionCookieConfig, JSPConfig jspConfig, String defaultEncoding, boolean useListenerEncoding, boolean ignoreFlush, boolean eagerFilterInit, int defaultSessionTimeout, boolean disableCachingForSecuredPages, boolean websocketsEnabled, boolean dispatchWebsocketInvocationToWorker) {
        this.allowNonStandardWrappers = allowNonStandardWrappers;
        this.stackTraces = stackTraces;
        this.sessionCookieConfig = sessionCookieConfig;
        this.jspConfig = jspConfig;
        this.defaultEncoding = defaultEncoding;
        this.useListenerEncoding = useListenerEncoding;
        this.ignoreFlush = ignoreFlush;
        this.eagerFilterInit = eagerFilterInit;
        this.defaultSessionTimeout = defaultSessionTimeout;
        this.disableCachingForSecuredPages = disableCachingForSecuredPages;
        this.websocketsEnabled = websocketsEnabled;
        this.dispatchWebsocketInvocationToWorker = dispatchWebsocketInvocationToWorker;
    }

    public void start(StartContext context) throws StartException {
        this.servletContainer = ServletContainer.Factory.newInstance();
    }

    public void stop(StopContext context) {
    }

    public ServletContainerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public boolean isAllowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public JSPConfig getJspConfig() {
        return this.jspConfig;
    }

    public ServletStackTraces getStackTraces() {
        return this.stackTraces;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    InjectedValue<DirectBufferCache> getBufferCacheInjectedValue() {
        return this.bufferCacheInjectedValue;
    }

    public DirectBufferCache getBufferCache() {
        return (DirectBufferCache)this.bufferCacheInjectedValue.getOptionalValue();
    }

    public boolean isDisableCachingForSecuredPages() {
        return this.disableCachingForSecuredPages;
    }

    public boolean isDispatchWebsocketInvocationToWorker() {
        return this.dispatchWebsocketInvocationToWorker;
    }

    public InjectedValue<XnioWorker> getWebsocketsWorker() {
        return this.websocketsWorker;
    }

    public InjectedValue<Pool<ByteBuffer>> getWebsocketsBufferPool() {
        return this.websocketsBufferPool;
    }

    public boolean isWebsocketsEnabled() {
        return this.websocketsEnabled;
    }

    InjectedValue<SessionPersistenceManager> getSessionPersistenceManagerInjectedValue() {
        return this.sessionPersistenceManagerInjectedValue;
    }

    public SessionPersistenceManager getSessionPersistenceManager() {
        return (SessionPersistenceManager)this.sessionPersistenceManagerInjectedValue.getOptionalValue();
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isUseListenerEncoding() {
        return this.useListenerEncoding;
    }

    public boolean isIgnoreFlush() {
        return this.ignoreFlush;
    }

    public boolean isEagerFilterInit() {
        return this.eagerFilterInit;
    }

    public int getDefaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }
}

