/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;

public class ModClusterContextDefinition
extends SimpleResourceDefinition {
    public static ModClusterContextDefinition INSTANCE = new ModClusterContextDefinition();
    public static final AttributeDefinition STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("status", ModelType.STRING).setAllowNull(true)).setStorageRuntime()).build();
    public static final AttributeDefinition REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("requests", ModelType.INT).setAllowNull(true)).setStorageRuntime()).build();
    public final OperationDefinition ENABLE = new SimpleOperationDefinition("enable", this.getResourceDescriptionResolver());
    public final OperationDefinition DISABLE = new SimpleOperationDefinition("disable", this.getResourceDescriptionResolver());

    ModClusterContextDefinition() {
        super(UndertowExtension.CONTEXT, (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "mod-cluster", "balancer", "node", "context"), null, null, true);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(STATUS, (OperationStepHandler)new AbstractContextOperation(){

            @Override
            public void handleContext(OperationContext context, ModClusterStatus.Context ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.isEnabled() ? "enabled" : "disabled"));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(REQUESTS, (OperationStepHandler)new AbstractContextOperation(){

            @Override
            public void handleContext(OperationContext context, ModClusterStatus.Context ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getRequests()));
            }
        });
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(this.ENABLE, (OperationStepHandler)new AbstractContextOperation(){

            @Override
            protected void handleContext(OperationContext context, ModClusterStatus.Context ctx, ModelNode operation) throws OperationFailedException {
                ctx.enable();
            }
        });
        resourceRegistration.registerOperationHandler(this.DISABLE, (OperationStepHandler)new AbstractContextOperation(){

            @Override
            protected void handleContext(OperationContext context, ModClusterStatus.Context ctx, ModelNode operation) throws OperationFailedException {
                ctx.disable();
            }
        });
    }

    private abstract class AbstractContextOperation
    implements OperationStepHandler {
        private AbstractContextOperation() {
        }

        public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String modClusterName;
            ModClusterService service;
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            int current = address.size() - 1;
            String contextName = address.getElement(current--).getValue();
            String nodeName = address.getElement(current--).getValue();
            String balancerName = address.getElement(current--).getValue();
            if ((service = ModClusterResource.service(modClusterName = address.getElement(current--).getValue())) == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.LoadBalancer balancer = service.getModCluster().getController().getStatus().getLoadBalancer(balancerName);
            if (balancer == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.Node node = balancer.getNode(nodeName);
            if (node == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.Context ctx = node.getContext(contextName);
            if (ctx == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            this.handleContext(context, ctx, operation);
        }

        protected abstract void handleContext(OperationContext var1, ModClusterStatus.Context var2, ModelNode var3) throws OperationFailedException;
    }
}

