/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.spec;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ALT_DD("alt-dd"),
    APPLICATION_NAME("application-name"),
    CONNECTOR("connector"),
    CONTEXT_ROOT("context-root"),
    EJB("ejb"),
    INITIALIZATION_IN_ORDER("initialize-in-order"),
    JAVA("java"),
    LIBRARY_DIRECTORY("library-directory"),
    MESSAGE_DESTINATION("message-destination"),
    MODULE("module"),
    SECURITY_ROLE("security-role"),
    WEB("web"),
    WEB_URI("web-uri");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

