/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTargetFilterCollection;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.FieldInfoGenerator;
import org.jboss.jandex.FieldInternal;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodInfoGenerator;
import org.jboss.jandex.MethodInternal;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.NameTable;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeTarget;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.Utils;
import org.jboss.jandex.VoidType;

public final class ClassInfo
implements AnnotationTarget {
    private final DotName name;
    private final short flags;
    private final Map<DotName, List<AnnotationInstance>> annotations;
    private Type[] interfaceTypes;
    private Type superClassType;
    private Type[] typeParameters;
    private MethodInternal[] methods;
    private FieldInternal[] fields;
    private boolean hasNoArgsConstructor;
    private NestingInfo nestingInfo;

    ClassInfo(DotName name, Type superClassType, short flags, Type[] interfaceTypes, Map<DotName, List<AnnotationInstance>> annotations) {
        this(name, superClassType, flags, interfaceTypes, annotations, false);
    }

    ClassInfo(DotName name, Type superClassType, short flags, Type[] interfaceTypes, Map<DotName, List<AnnotationInstance>> annotations, boolean hasNoArgsConstructor) {
        this.name = name;
        this.superClassType = superClassType;
        this.flags = flags;
        this.interfaceTypes = interfaceTypes.length == 0 ? Type.EMPTY_ARRAY : interfaceTypes;
        this.annotations = Collections.unmodifiableMap(annotations);
        this.hasNoArgsConstructor = hasNoArgsConstructor;
        this.typeParameters = Type.EMPTY_ARRAY;
    }

    @Deprecated
    public static ClassInfo create(DotName name, DotName superName, short flags, DotName[] interfaces, Map<DotName, List<AnnotationInstance>> annotations, boolean hasNoArgsConstructor) {
        Type[] interfaceTypes = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceTypes[i] = new ClassType(interfaces[i]);
        }
        ClassType superClassType = superName == null ? null : new ClassType(superName);
        return new ClassInfo(name, superClassType, flags, interfaceTypes, annotations, hasNoArgsConstructor);
    }

    @Override
    public final AnnotationTarget.Kind kind() {
        return AnnotationTarget.Kind.CLASS;
    }

    public String toString() {
        return this.name.toString();
    }

    public final DotName name() {
        return this.name;
    }

    public final short flags() {
        return this.flags;
    }

    public final DotName superName() {
        return this.superClassType == null ? null : this.superClassType.name();
    }

    @Deprecated
    public final DotName[] interfaces() {
        DotName[] interfaces = new DotName[this.interfaceTypes.length];
        for (int i = 0; i < this.interfaceTypes.length; ++i) {
            interfaces[i] = this.interfaceTypes[i].name();
        }
        return interfaces;
    }

    public final Map<DotName, List<AnnotationInstance>> annotations() {
        return this.annotations;
    }

    public final Collection<AnnotationInstance> classAnnotations() {
        return new AnnotationTargetFilterCollection<ClassInfo>(this.annotations, ClassInfo.class);
    }

    public final List<MethodInfo> methods() {
        return new MethodInfoGenerator(this, this.methods);
    }

    final MethodInternal[] methodArray() {
        return this.methods;
    }

    public final MethodInfo method(String name, Type ... parameters) {
        MethodInternal key = new MethodInternal(Utils.toUTF8(name), parameters, null, 0);
        int i = Arrays.binarySearch(this.methods, key, MethodInternal.NAME_AND_PARAMETER_COMPONENT_COMPARATOR);
        return i >= 0 ? new MethodInfo(this, this.methods[i]) : null;
    }

    public final MethodInfo firstMethod(String name) {
        MethodInternal key = new MethodInternal(Utils.toUTF8(name), Type.EMPTY_ARRAY, null, 0);
        int i = Arrays.binarySearch(this.methods, key, MethodInternal.NAME_AND_PARAMETER_COMPONENT_COMPARATOR);
        if (i < -this.methods.length) {
            return null;
        }
        MethodInfo method = new MethodInfo(this, i >= 0 ? this.methods[i] : this.methods[++i * -1]);
        return method.name().equals(name) ? method : null;
    }

    public final FieldInfo field(String name) {
        FieldInternal key = new FieldInternal(Utils.toUTF8(name), VoidType.VOID, 0);
        int i = Arrays.binarySearch(this.fields, key, FieldInternal.NAME_COMPARATOR);
        if (i < 0) {
            return null;
        }
        return new FieldInfo(this, this.fields[i]);
    }

    public final List<FieldInfo> fields() {
        return new FieldInfoGenerator(this, this.fields);
    }

    final FieldInternal[] fieldArray() {
        return this.fields;
    }

    public final List<DotName> interfaceNames() {
        return new AbstractList<DotName>(){

            @Override
            public DotName get(int i) {
                return ClassInfo.this.interfaceTypes[i].name();
            }

            @Override
            public int size() {
                return ClassInfo.this.interfaceTypes.length;
            }
        };
    }

    public final List<Type> interfaceTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.interfaceTypes));
    }

    final Type[] interfaceTypeArray() {
        return this.interfaceTypes;
    }

    final Type[] copyInterfaceTypes() {
        return (Type[])this.interfaceTypes.clone();
    }

    public final Type superClassType() {
        return this.superClassType;
    }

    public final List<TypeVariable> typeParameters() {
        List<Type> list = Arrays.asList(this.typeParameters);
        return Collections.unmodifiableList(list);
    }

    final Type[] typeParameterArray() {
        return this.typeParameters;
    }

    public final boolean hasNoArgsConstructor() {
        return this.hasNoArgsConstructor;
    }

    public NestingType nestingType() {
        if (this.nestingInfo == null) {
            return NestingType.TOP_LEVEL;
        }
        if (this.nestingInfo.enclosingClass != null) {
            return NestingType.INNER;
        }
        if (this.nestingInfo.simpleName != null) {
            return NestingType.LOCAL;
        }
        return NestingType.ANONYMOUS;
    }

    public String simpleName() {
        return this.nestingInfo != null ? this.nestingInfo.simpleName : null;
    }

    public DotName enclosingClass() {
        return this.nestingInfo != null ? this.nestingInfo.enclosingClass : null;
    }

    public EnclosingMethodInfo enclosingMethod() {
        return this.nestingInfo != null ? this.nestingInfo.enclosingMethod : null;
    }

    @Override
    public ClassInfo asClass() {
        return this;
    }

    @Override
    public FieldInfo asField() {
        throw new IllegalArgumentException("Not a field");
    }

    @Override
    public MethodInfo asMethod() {
        throw new IllegalArgumentException("Not a method");
    }

    @Override
    public MethodParameterInfo asMethodParameter() {
        throw new IllegalArgumentException("Not a method parameter");
    }

    @Override
    public TypeTarget asType() {
        throw new IllegalArgumentException("Not a type");
    }

    void setHasNoArgsConstructor(boolean hasNoArgsConstructor) {
        this.hasNoArgsConstructor = hasNoArgsConstructor;
    }

    void setFields(List<FieldInfo> fields, NameTable names) {
        if (fields.size() == 0) {
            this.fields = FieldInternal.EMPTY_ARRAY;
            return;
        }
        this.fields = new FieldInternal[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo fieldInfo = fields.get(i);
            FieldInternal internal = names.intern(fieldInfo.fieldInternal());
            fieldInfo.setFieldInternal(internal);
            this.fields[i] = internal;
        }
        Arrays.sort(this.fields, FieldInternal.NAME_COMPARATOR);
    }

    void setFieldArray(FieldInternal[] fields) {
        this.fields = fields;
    }

    void setMethodArray(MethodInternal[] methods) {
        this.methods = methods;
    }

    void setMethods(List<MethodInfo> methods, NameTable names) {
        if (methods.size() == 0) {
            this.methods = MethodInternal.EMPTY_ARRAY;
            return;
        }
        this.methods = new MethodInternal[methods.size()];
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo methodInfo = methods.get(i);
            MethodInternal internal = names.intern(methodInfo.methodInternal());
            methodInfo.setMethodInternal(internal);
            this.methods[i] = internal;
        }
        Arrays.sort(this.methods, MethodInternal.NAME_AND_PARAMETER_COMPONENT_COMPARATOR);
    }

    void setSuperClassType(Type superClassType) {
        this.superClassType = superClassType;
    }

    void setInterfaceTypes(Type[] interfaceTypes) {
        this.interfaceTypes = interfaceTypes.length == 0 ? Type.EMPTY_ARRAY : interfaceTypes;
    }

    void setTypeParameters(Type[] typeParameters) {
        this.typeParameters = typeParameters.length == 0 ? Type.EMPTY_ARRAY : typeParameters;
    }

    void setInnerClassInfo(DotName enclosingClass, String simpleName) {
        if (enclosingClass == null && simpleName == null) {
            return;
        }
        if (this.nestingInfo == null) {
            this.nestingInfo = new NestingInfo();
        }
        this.nestingInfo.enclosingClass = enclosingClass;
        this.nestingInfo.simpleName = simpleName;
    }

    void setEnclosingMethod(EnclosingMethodInfo enclosingMethod) {
        if (enclosingMethod == null) {
            return;
        }
        if (this.nestingInfo == null) {
            this.nestingInfo = new NestingInfo();
        }
        this.nestingInfo.enclosingMethod = enclosingMethod;
    }

    public static final class EnclosingMethodInfo {
        private String name;
        private Type returnType;
        private Type[] parameters;
        private DotName enclosingClass;

        public String name() {
            return this.name;
        }

        public Type returnType() {
            return this.returnType;
        }

        public List<Type> parameters() {
            return Collections.unmodifiableList(Arrays.asList(this.parameters));
        }

        Type[] parametersArray() {
            return this.parameters;
        }

        public DotName enclosingClass() {
            return this.enclosingClass;
        }

        EnclosingMethodInfo(String name, Type returnType, Type[] parameters, DotName enclosingClass) {
            this.name = name;
            this.returnType = returnType;
            this.parameters = parameters;
            this.enclosingClass = enclosingClass;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.returnType).append(' ').append(this.enclosingClass).append('.').append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                builder.append(this.parameters[i]);
                if (i + 1 >= this.parameters.length) continue;
                builder.append(", ");
            }
            builder.append(')');
            return builder.toString();
        }
    }

    private static final class NestingInfo {
        private DotName enclosingClass;
        private String simpleName;
        private EnclosingMethodInfo enclosingMethod;

        private NestingInfo() {
        }
    }

    public static enum NestingType {
        TOP_LEVEL,
        INNER,
        LOCAL,
        ANONYMOUS;

    }
}

