/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security._private;

import java.io.EOFException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableKeyException;
import javax.security.auth.callback.Callback;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServerFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.util.DecodeException;

@MessageLogger(projectCode="ELY", length=5)
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");
    public static final ElytronMessages xmlLog = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.xml");

    @LogMessage
    @Message(id=1, value="WildFly Elytron version %s")
    public void logVersion(String var1);

    @Message(value="Parse error")
    public String parseError();

    @Message(id=7, value="Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)")
    public ConfigXMLParseException xmlInvalidPortNumber(@Param XMLStreamReader var1, String var2, String var3, QName var4);

    @Message(id=11, value="%s is null")
    public IllegalArgumentException nullParameter(String var1);

    @Message(id=12, value="Realm map does not contain mapping for default realm '%s'")
    public IllegalArgumentException realmMapDoesntContainDefault(String var1);

    @Message(id=13, value="This builder has already been built")
    public IllegalStateException builderAlreadyBuilt();

    @Message(id=14, value="Invalid key store entry password for alias \"%s\"")
    public UnrecoverableKeyException invalidKeyStoreEntryPassword(String var1);

    @Message(id=15, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public KeyStoreException invalidKeyStoreEntryType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=16, value="Key store key for alias \"%s\" cannot be protected")
    public KeyStoreException keyCannotBeProtected(String var1);

    @Message(id=17, value="Key store failed to translate password for alias \"%s\"")
    public IOException keyStoreFailedToTranslate(String var1, @Cause Throwable var2);

    @Message(id=18, value="Key store failed to identify a suitable algorithm for alias \"%s\"")
    public NoSuchAlgorithmException noAlgorithmForPassword(String var1);

    @Message(id=19, value="Unexpected whitespace in password file")
    public IOException unexpectedWhitespaceInPasswordFile();

    @Message(id=20, value="Unexpected end of file")
    public EOFException unexpectedEof();

    @Message(id=21, value="SASL exchange received a message after authentication was already complete")
    public SaslException saslMessageAfterComplete();

    @Message(id=22, value="SASL user name contains an invalid or disallowed character")
    public SaslException saslUserNameContainsInvalidCharacter();

    @Message(id=23, value="SASL user name could not be decoded from encoding \"%s\"")
    public SaslException saslUserNameDecodeFailed(String var1);

    @Message(id=24, value="SASL authorization failed")
    public SaslException saslAuthorizationFailed(@Cause Throwable var1);

    @Message(id=25, value="SASL authentication is not yet complete")
    public IllegalStateException saslAuthenticationNotComplete();

    @Message(id=26, value="No SASL security layer is currently in force")
    public SaslException saslNoSecurityLayer();

    @Message(id=27, value="Invalid SASL negotiation message received")
    public SaslException saslInvalidMessageReceived();

    @Message(id=28, value="SASL client-side authentication failed")
    public SaslException saslClientSideAuthenticationFailed(@Cause Exception var1);

    @Message(id=29, value="No SASL login name was given")
    public SaslException saslNoLoginNameGiven();

    @Message(id=30, value="No SASL password was given")
    public SaslException saslNoPasswordGiven();

    @Message(id=31, value="SASL authentication failed due to one or more malformed fields")
    public SaslException saslMalformedFields(@Cause IllegalArgumentException var1);

    @Message(id=32, value="SASL message is too long")
    public SaslException saslMessageTooLong();

    @Message(id=33, value="SASL server-side authentication failed")
    public SaslException saslServerSideAuthenticationFailed(@Cause Exception var1);

    @Message(id=34, value="SASL password not verified")
    public SaslException saslPasswordNotVerified();

    @Message(id=35, value="SASL authorization failed: \"%s\" is not authorized to act on behalf of \"%s\"")
    public SaslException saslAuthorizationFailed(String var1, String var2);

    @Message(id=36, value="Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedChar(int var1, int var2, String var3);

    @Message(id=37, value="Unrecognized token \"%s\" in mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnknownToken(String var1, String var2);

    @Message(id=38, value="Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenNotAllowed(String var1, int var2, String var3);

    @Message(id=39, value="Expected token \"%s\" at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenExpected(String var1, int var2, String var3);

    @Message(id=40, value="Proxied SASL authentication failed")
    public SaslException saslProxyAuthenticationFailed();

    @Message(id=41, value="No SASL client mechanism \"%s\" is available with the current configuration from %s")
    public SaslException saslNoClientMechanism(String var1, SaslClientFactory var2);

    @Message(id=42, value="No SASL server mechanism \"%s\" is available with the current configuration from %s")
    public SaslException saslNoServerMechanism(String var1, SaslServerFactory var2);

    @Message(id=43, value="A revertable load is not possible until the KeyStore has first been initialised")
    public IllegalStateException revertableLoadNotPossible();

    @Message(id=44, value="Unable to create a new KeyStore instance")
    public IOException unableToCreateKeyStore(@Cause Exception var1);

    @Message(id=45, value="Invalid password type for alias %s (expected %s, got %s)")
    public KeyStoreException invalidPasswordType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=46, value="The password entry must contain a non null realm name")
    public KeyStoreException invalidNullRealmInPasswordEntry();

    @Message(id=47, value="The password entry realm for alias %s must match the properties-based keystore realm. (expected %s, got %s)")
    public KeyStoreException invalidRealmNameInPasswordEntry(String var1, String var2, String var3);

    @Message(id=48, value="Invalid algorithm found in password entry for alias %s (expected %s, got %s)")
    public KeyStoreException invalidAlgorithmInPasswordEntry(String var1, String var2, String var3);

    @Message(id=49, value="No realm name found in properties file")
    public IOException noRealmFoundInProperties();

    @Message(id=50, value="Unexpected padding")
    public DecodeException unexpectedPadding();

    @Message(id=51, value="Expected padding")
    public DecodeException expectedPadding();

    @Message(id=52, value="Incomplete decode")
    public DecodeException incompleteDecode();

    @Message(id=53, value="Expected %d padding characters")
    public DecodeException expectedPaddingCharacters(int var1);

    @Message(id=54, value="Invalid base 32 character")
    public DecodeException invalidBase32Character();

    @Message(id=55, value="Expected an even number of hex characters")
    public DecodeException expectedEvenNumberOfHexCharacters();

    @Message(id=56, value="Invalid hex character")
    public DecodeException invalidHexCharacter();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=57, value="JAAS authentication failed for principal %s")
    public void debugJAASAuthenticationFailure(Principal var1, @Cause Throwable var2);

    @Message(id=58, value="Invalid principal type (expected %s, got %s)")
    public IllegalArgumentException invalidPrincipalType(Class<?> var1, Class<?> var2);

    @Message(id=59, value="Failed to create login context")
    public RealmUnavailableException failedToCreateLoginContext(@Cause Throwable var1);

    @Message(id=60, value="Failed to instantiate custom CallbackHandler")
    public RealmUnavailableException failedToInstantiateCustomHandler(@Cause Throwable var1);

    @Message(id=61, value="The Callback array cannot be null")
    public IllegalArgumentException invalidNullCallbackArray();

    @Message(id=62, value="Credential cannot be converted to a password")
    public FastUnsupportedCallbackException failedToConvertCredentialToPassword(@Param Callback var1);
}

