/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;

final class KeyStoreEntrySecurityFactory
implements SecurityFactory<KeyStore.Entry> {
    private final SecurityFactory<KeyStore> keyStore;
    private final String alias;
    private final SecurityFactory<KeyStore.ProtectionParameter> protectionParameter;

    KeyStoreEntrySecurityFactory(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        this(new FixedSecurityFactory<KeyStore>(keyStore), alias, new FixedSecurityFactory<KeyStore.ProtectionParameter>(protectionParameter));
    }

    KeyStoreEntrySecurityFactory(SecurityFactory<KeyStore> keyStore, String alias, SecurityFactory<KeyStore.ProtectionParameter> protectionParameter) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.protectionParameter = protectionParameter;
    }

    @Override
    public KeyStore.Entry create() throws GeneralSecurityException {
        return this.keyStore.create().getEntry(this.alias, this.protectionParameter == null ? null : this.protectionParameter.create());
    }
}

