/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.security.auth.util.RealmMapper;

public class SimpleRegexRealmMapper
implements RealmMapper {
    private final Pattern realmNamePattern;

    public SimpleRegexRealmMapper(Pattern realmNamePattern) {
        int groupCount = realmNamePattern.matcher("").groupCount();
        if (groupCount < 1) {
            throw new IllegalArgumentException("Pattern requires a capture group");
        }
        this.realmNamePattern = realmNamePattern;
    }

    @Override
    public String getRealmMapping(String userName) {
        Matcher matcher = this.realmNamePattern.matcher(userName);
        assert (matcher.groupCount() >= 1);
        return matcher.matches() ? matcher.group(1) : null;
    }
}

