/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class DefaultAccessLogReceiver
implements AccessLogReceiver,
Runnable,
Closeable {
    private static final String DEFAULT_LOG_SUFFIX = ".log";
    private final Executor logWriteExecutor;
    private final Deque<String> pendingMessages;
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<DefaultAccessLogReceiver> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultAccessLogReceiver.class, "state");
    private long changeOverPoint;
    private String currentDateString;
    private boolean forceLogRotation;
    private final Path outputDirectory;
    private final Path defaultLogFile;
    private final String logBaseName;
    private final String logNameSuffix;
    private Writer writer = null;
    private volatile boolean closed = false;
    private boolean initialRun = true;
    private final boolean rotate;

    public DefaultAccessLogReceiver(Executor logWriteExecutor, File outputDirectory, String logBaseName) {
        this(logWriteExecutor, outputDirectory.toPath(), logBaseName, null);
    }

    public DefaultAccessLogReceiver(Executor logWriteExecutor, File outputDirectory, String logBaseName, String logNameSuffix) {
        this(logWriteExecutor, outputDirectory.toPath(), logBaseName, logNameSuffix, true);
    }

    public DefaultAccessLogReceiver(Executor logWriteExecutor, File outputDirectory, String logBaseName, String logNameSuffix, boolean rotate) {
        this(logWriteExecutor, outputDirectory.toPath(), logBaseName, logNameSuffix, rotate);
    }

    public DefaultAccessLogReceiver(Executor logWriteExecutor, Path outputDirectory, String logBaseName) {
        this(logWriteExecutor, outputDirectory, logBaseName, null);
    }

    public DefaultAccessLogReceiver(Executor logWriteExecutor, Path outputDirectory, String logBaseName, String logNameSuffix) {
        this(logWriteExecutor, outputDirectory, logBaseName, logNameSuffix, true);
    }

    public DefaultAccessLogReceiver(Executor logWriteExecutor, Path outputDirectory, String logBaseName, String logNameSuffix, boolean rotate) {
        this.logWriteExecutor = logWriteExecutor;
        this.outputDirectory = outputDirectory;
        this.logBaseName = logBaseName;
        this.rotate = rotate;
        this.logNameSuffix = logNameSuffix != null ? logNameSuffix : DEFAULT_LOG_SUFFIX;
        this.pendingMessages = new ConcurrentLinkedDeque<String>();
        this.defaultLogFile = outputDirectory.resolve(logBaseName + this.logNameSuffix);
        this.calculateChangeOverPoint();
    }

    private void calculateChangeOverPoint() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        calendar.add(5, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.currentDateString = df.format(new Date());
        this.changeOverPoint = calendar.getTimeInMillis();
    }

    @Override
    public void logMessage(String message) {
        this.pendingMessages.add(message);
        int state = stateUpdater.get(this);
        if (state == 0 && stateUpdater.compareAndSet(this, 0, 1)) {
            this.logWriteExecutor.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String msg;
        if (!stateUpdater.compareAndSet(this, 1, 2)) {
            return;
        }
        if (this.forceLogRotation) {
            this.doRotate();
        } else if (this.initialRun && Files.exists(this.defaultLogFile, new LinkOption[0])) {
            long lm = 0L;
            try {
                lm = Files.getLastModifiedTime(this.defaultLogFile, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                UndertowLogger.ROOT_LOGGER.errorRotatingAccessLog(e);
            }
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.changeOverPoint);
            c.add(5, -1);
            if (lm <= c.getTimeInMillis()) {
                this.doRotate();
            }
        }
        this.initialRun = false;
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < 1000 && (msg = this.pendingMessages.poll()) != null; ++i) {
            messages.add(msg);
        }
        try {
            if (!messages.isEmpty()) {
                this.writeMessage(messages);
            }
        }
        finally {
            stateUpdater.set(this, 0);
            if (!this.pendingMessages.isEmpty() || this.forceLogRotation) {
                if (stateUpdater.compareAndSet(this, 0, 1)) {
                    this.logWriteExecutor.execute(this);
                }
            } else if (this.closed) {
                try {
                    this.writer.flush();
                    this.writer.close();
                    this.writer = null;
                }
                catch (IOException e) {
                    UndertowLogger.ROOT_LOGGER.errorWritingAccessLog(e);
                }
            }
        }
    }

    void awaitWrittenForTest() throws InterruptedException {
        while (!this.pendingMessages.isEmpty() || this.forceLogRotation) {
            Thread.sleep(10L);
        }
        while (this.state != 0) {
            Thread.sleep(10L);
        }
    }

    private void writeMessage(List<String> messages) {
        if (System.currentTimeMillis() > this.changeOverPoint) {
            this.doRotate();
        }
        try {
            if (this.writer == null) {
                this.writer = Files.newBufferedWriter(this.defaultLogFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            for (String message : messages) {
                this.writer.write(message);
                this.writer.write(10);
            }
            this.writer.flush();
        }
        catch (IOException e) {
            UndertowLogger.ROOT_LOGGER.errorWritingAccessLog(e);
        }
    }

    private void doRotate() {
        this.forceLogRotation = false;
        if (!this.rotate) {
            return;
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (!Files.exists(this.defaultLogFile, new LinkOption[0])) {
                return;
            }
            Path newFile = this.outputDirectory.resolve(this.logBaseName + "_" + this.currentDateString + this.logNameSuffix);
            int count = 0;
            while (Files.exists(newFile, new LinkOption[0])) {
                newFile = this.outputDirectory.resolve(this.logBaseName + "_" + this.currentDateString + "-" + ++count + this.logNameSuffix);
            }
            Files.move(this.defaultLogFile, newFile, new CopyOption[0]);
        }
        catch (IOException e) {
            UndertowLogger.ROOT_LOGGER.errorRotatingAccessLog(e);
        }
        finally {
            this.calculateChangeOverPoint();
        }
    }

    public void rotate() {
        this.forceLogRotation = true;
        if (stateUpdater.compareAndSet(this, 0, 1)) {
            this.logWriteExecutor.execute(this);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (stateUpdater.compareAndSet(this, 0, 1)) {
            this.logWriteExecutor.execute(this);
        }
    }
}

