/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import java.util.List;
import org.jboss.as.naming.deployment.RuntimeBindReleaseService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class JndiNamingDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName JNDI_DEPENDENCY_SERVICE = ServiceName.of((String[])new String[]{"jndiDependencyService"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, (Object)NamingService.SERVICE_NAME);
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List dependencies = deploymentUnit.getAttachmentList(Attachments.JNDI_DEPENDENCIES);
        ServiceName serviceName = JndiNamingDependencyProcessor.serviceName(deploymentUnit.getServiceName());
        ServiceBuilder serviceBuilder = phaseContext.getServiceTarget().addService(serviceName, (Service)new RuntimeBindReleaseService());
        serviceBuilder.addDependencies((Iterable)dependencies);
        if (deploymentUnit.getParent() != null) {
            serviceBuilder.addDependencies((Iterable)deploymentUnit.getParent().getAttachment(Attachments.JNDI_DEPENDENCIES));
        }
        serviceBuilder.addDependency(NamingService.SERVICE_NAME);
        serviceBuilder.install();
    }

    public static ServiceName serviceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(JNDI_DEPENDENCY_SERVICE);
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return JndiNamingDependencyProcessor.serviceName(deploymentUnit.getServiceName());
    }

    public void undeploy(DeploymentUnit context) {
    }
}

