/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedBindingRegistry;
import org.jboss.as.network.ManagedDatagramSocketBinding;
import org.jboss.as.network.ManagedMulticastSocketBinding;
import org.jboss.as.network.ManagedServerSocketBinding;
import org.jboss.as.network.ManagedServerSocketFactory;
import org.jboss.as.network.ManagedSocketBinding;
import org.jboss.as.network.ManagedSocketFactory;
import org.jboss.as.network.SocketBindingManager;

public abstract class SocketBindingManagerImpl
implements SocketBindingManager {
    private final ManagedSocketFactory socketFactory = new ManagedSocketFactoryImpl();
    private final ManagedServerSocketFactory serverSocketFactory = new ManagedServerSocketFactoryImpl();
    private final SocketBindingManager.NamedManagedBindingRegistry namedRegistry = new NamedRegistryImpl();
    private final SocketBindingManager.UnnamedBindingRegistry unnamedRegistry = new UnnamedRegistryImpl();

    @Override
    public ManagedServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Override
    public ManagedSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public DatagramSocket createDatagramSocket(String name, SocketAddress address) throws SocketException {
        return new ManagedDatagramSocketBinding(null, this.namedRegistry, address);
    }

    @Override
    public DatagramSocket createDatagramSocket(SocketAddress address) throws SocketException {
        return new ManagedDatagramSocketBinding(null, this.unnamedRegistry, address);
    }

    @Override
    public MulticastSocket createMulticastSocket(String name, SocketAddress address) throws IOException {
        return ManagedMulticastSocketBinding.create(null, this.unnamedRegistry, address);
    }

    @Override
    public MulticastSocket createMulticastSocket(SocketAddress address) throws IOException {
        return ManagedMulticastSocketBinding.create(null, this.unnamedRegistry, address);
    }

    @Override
    public SocketBindingManager.NamedManagedBindingRegistry getNamedRegistry() {
        return this.namedRegistry;
    }

    @Override
    public SocketBindingManager.UnnamedBindingRegistry getUnnamedRegistry() {
        return this.unnamedRegistry;
    }

    static final class UnnamedRegistryImpl
    implements SocketBindingManager.UnnamedBindingRegistry {
        private final Map<InetSocketAddress, ManagedBinding> bindings = new ConcurrentHashMap<InetSocketAddress, ManagedBinding>();

        UnnamedRegistryImpl() {
        }

        @Override
        public void registerBinding(ManagedBinding binding) {
            InetSocketAddress address = binding.getBindAddress();
            if (address == null) {
                throw new IllegalStateException();
            }
            this.bindings.put(address, new WrappedManagedBinding(binding, this));
        }

        @Override
        public void unregisterBinding(ManagedBinding binding) {
            InetSocketAddress address = binding.getBindAddress();
            if (address == null) {
                throw new IllegalStateException();
            }
            this.unregisterBinding(address);
        }

        @Override
        public Collection<ManagedBinding> listActiveBindings() {
            return new HashSet<ManagedBinding>(this.bindings.values());
        }

        @Override
        public Closeable registerSocket(Socket socket) {
            WrappedManagedSocket binding = new WrappedManagedSocket(socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(ServerSocket socket) {
            WrappedManagedServerSocket binding = new WrappedManagedServerSocket(socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(DatagramSocket socket) {
            WrappedManagedDatagramSocket binding = new WrappedManagedDatagramSocket(socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(SocketChannel channel) {
            CloseableManagedBinding binding = new CloseableManagedBinding((InetSocketAddress)channel.socket().getLocalSocketAddress(), channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(ServerSocketChannel channel) {
            CloseableManagedBinding binding = new CloseableManagedBinding((InetSocketAddress)channel.socket().getLocalSocketAddress(), channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(DatagramChannel channel) {
            CloseableManagedBinding binding = new CloseableManagedBinding((InetSocketAddress)channel.socket().getLocalSocketAddress(), channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public void unregisterSocket(Socket socket) {
            this.unregisterBinding((InetSocketAddress)socket.getLocalSocketAddress());
        }

        @Override
        public void unregisterSocket(ServerSocket socket) {
            this.unregisterBinding((InetSocketAddress)socket.getLocalSocketAddress());
        }

        @Override
        public void unregisterSocket(DatagramSocket socket) {
            this.unregisterBinding((InetSocketAddress)socket.getLocalSocketAddress());
        }

        @Override
        public void unregisterChannel(SocketChannel channel) {
            this.unregisterBinding((InetSocketAddress)channel.socket().getLocalSocketAddress());
        }

        @Override
        public void unregisterChannel(ServerSocketChannel channel) {
            this.unregisterBinding((InetSocketAddress)channel.socket().getLocalSocketAddress());
        }

        @Override
        public void unregisterChannel(DatagramChannel channel) {
            this.unregisterBinding((InetSocketAddress)channel.socket().getLocalSocketAddress());
        }

        public void unregisterBinding(InetSocketAddress address) {
            if (address != null) {
                this.bindings.remove(address);
            }
        }
    }

    static final class NamedRegistryImpl
    implements SocketBindingManager.NamedManagedBindingRegistry {
        private final Map<String, ManagedBinding> bindings = new ConcurrentHashMap<String, ManagedBinding>();

        NamedRegistryImpl() {
        }

        @Override
        public ManagedBinding getManagedBinding(String name) {
            return this.bindings.get(name);
        }

        @Override
        public boolean isRegistered(String name) {
            return this.bindings.containsKey(name);
        }

        @Override
        public void registerBinding(ManagedBinding binding) {
            String name = binding.getSocketBindingName();
            if (name == null) {
                throw new IllegalStateException();
            }
            this.bindings.put(name, new WrappedManagedBinding(binding, this));
        }

        @Override
        public void unregisterBinding(ManagedBinding binding) {
            String name = binding.getSocketBindingName();
            if (name == null) {
                throw new IllegalStateException();
            }
            this.unregisterBinding(name);
        }

        @Override
        public Collection<ManagedBinding> listActiveBindings() {
            return new HashSet<ManagedBinding>(this.bindings.values());
        }

        @Override
        public Closeable registerSocket(String name, Socket socket) {
            WrappedManagedSocket binding = new WrappedManagedSocket(name, socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(String name, ServerSocket socket) {
            WrappedManagedServerSocket binding = new WrappedManagedServerSocket(name, socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(String name, DatagramSocket socket) {
            WrappedManagedDatagramSocket binding = new WrappedManagedDatagramSocket(name, socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(String name, SocketChannel channel) {
            CloseableManagedBinding binding = new CloseableManagedBinding(name, (InetSocketAddress)channel.socket().getLocalSocketAddress(), channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(String name, ServerSocketChannel channel) {
            CloseableManagedBinding binding = new CloseableManagedBinding(name, (InetSocketAddress)channel.socket().getLocalSocketAddress(), channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(String name, DatagramChannel channel) {
            CloseableManagedBinding binding = new CloseableManagedBinding(name, (InetSocketAddress)channel.socket().getLocalSocketAddress(), channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public void unregisterBinding(String name) {
            if (name == null) {
                return;
            }
            this.bindings.remove(name);
        }
    }

    static class WrappedManagedServerSocket
    implements ManagedBinding {
        private final String name;
        private final ServerSocket socket;
        private final ManagedBindingRegistry registry;

        public WrappedManagedServerSocket(ServerSocket socket, ManagedBindingRegistry registry) {
            this(null, socket, registry);
        }

        public WrappedManagedServerSocket(String name, ServerSocket socket, ManagedBindingRegistry registry) {
            this.name = name;
            this.socket = socket;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.socket.close();
            }
            finally {
                this.registry.unregisterBinding(this);
            }
        }
    }

    static class WrappedManagedSocket
    implements ManagedBinding {
        private final String name;
        private final Socket socket;
        private final ManagedBindingRegistry registry;

        public WrappedManagedSocket(Socket socket, ManagedBindingRegistry registry) {
            this(null, socket, registry);
        }

        public WrappedManagedSocket(String name, Socket socket, ManagedBindingRegistry registry) {
            this.name = name;
            this.socket = socket;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.socket.close();
            }
            finally {
                this.registry.unregisterBinding(this);
            }
        }
    }

    static class WrappedManagedBinding
    implements ManagedBinding {
        private final ManagedBinding wrapped;
        private final ManagedBindingRegistry registry;

        public WrappedManagedBinding(ManagedBinding wrapped, ManagedBindingRegistry registry) {
            this.wrapped = wrapped;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.wrapped.getSocketBindingName();
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return this.wrapped.getBindAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.wrapped.close();
            }
            finally {
                this.registry.unregisterBinding(this);
            }
        }
    }

    static class WrappedManagedDatagramSocket
    implements ManagedBinding {
        private final String name;
        private final DatagramSocket socket;
        private final ManagedBindingRegistry registry;

        public WrappedManagedDatagramSocket(DatagramSocket socket, ManagedBindingRegistry registry) {
            this(null, socket, registry);
        }

        public WrappedManagedDatagramSocket(String name, DatagramSocket socket, ManagedBindingRegistry registry) {
            this.name = name;
            this.socket = socket;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.socket.close();
            }
            finally {
                this.registry.unregisterBinding(this);
            }
        }
    }

    static class CloseableManagedBinding
    implements ManagedBinding {
        private final String name;
        private final InetSocketAddress address;
        private final Closeable closeable;
        private final ManagedBindingRegistry registry;

        CloseableManagedBinding(InetSocketAddress address, Closeable closeable, ManagedBindingRegistry registry) {
            this(null, address, closeable, registry);
        }

        CloseableManagedBinding(String name, InetSocketAddress address, Closeable closeable, ManagedBindingRegistry registry) {
            this.name = name;
            this.address = address;
            this.closeable = closeable;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return this.address;
        }

        @Override
        public void close() throws IOException {
            try {
                this.closeable.close();
            }
            finally {
                this.registry.unregisterBinding(this);
            }
        }
    }

    class ManagedServerSocketFactoryImpl
    extends ManagedServerSocketFactory {
        ManagedServerSocketFactoryImpl() {
        }

        @Override
        public ServerSocket createServerSocket(String name) throws IOException {
            return new ManagedServerSocketBinding(name, SocketBindingManagerImpl.this);
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return this.createServerSocket(null);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.createServerSocket(null, port);
        }

        @Override
        public ServerSocket createServerSocket(String name, int port) throws IOException {
            ServerSocket serverSocket = this.createServerSocket(name);
            serverSocket.bind(new InetSocketAddress(port));
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.createServerSocket(null, port, backlog);
        }

        @Override
        public ServerSocket createServerSocket(String name, int port, int backlog) throws IOException {
            ServerSocket serverSocket = this.createServerSocket(name);
            serverSocket.bind(new InetSocketAddress(port), backlog);
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return this.createServerSocket(null, port, backlog, ifAddress);
        }

        @Override
        public ServerSocket createServerSocket(String name, int port, int backlog, InetAddress ifAddress) throws IOException {
            ServerSocket serverSocket = this.createServerSocket(name);
            serverSocket.bind(new InetSocketAddress(ifAddress, port), backlog);
            return serverSocket;
        }
    }

    class ManagedSocketFactoryImpl
    extends ManagedSocketFactory {
        ManagedSocketFactoryImpl() {
        }

        @Override
        public Socket createSocket() {
            return new ManagedSocketBinding(SocketBindingManagerImpl.this.unnamedRegistry);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.createSocket(InetAddress.getByName(host), port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket();
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.createSocket(InetAddress.getByName(host), port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket();
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }

        @Override
        public Socket createSocket(String name) {
            return new ManagedSocketBinding(name, SocketBindingManagerImpl.this.namedRegistry);
        }

        @Override
        public Socket createSocket(String name, String host, int port) throws IOException {
            return this.createSocket(name, InetAddress.getByName(host), port);
        }

        @Override
        public Socket createSocket(String name, InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket(name);
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        @Override
        public Socket createSocket(String name, String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.createSocket(name, InetAddress.getByName(host), port, localHost, localPort);
        }

        @Override
        public Socket createSocket(String name, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket(name);
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }
    }
}

