/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.io.BufferPoolService;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.IOServices;
import org.xnio.Pool;

class BufferPoolResourceDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> IO_POOL_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.io.buffer-pool", (boolean)true, Pool.class).build();
    private static final int defaultBufferSize;
    private static final int defaultBuffersPerRegion;
    private static final boolean defaultDirectBuffers;
    static final SimpleAttributeDefinition BUFFER_SIZE;
    static final SimpleAttributeDefinition BUFFER_PER_SLICE;
    static final SimpleAttributeDefinition DIRECT_BUFFERS;
    static List<SimpleAttributeDefinition> ATTRIBUTES;
    public static final BufferPoolResourceDefinition INSTANCE;

    private BufferPoolResourceDefinition() {
        super(IOExtension.BUFFER_POOL_PATH, (ResourceDescriptionResolver)IOExtension.getResolver("buffer-pool"), (OperationStepHandler)new BufferPoolAdd(), (OperationStepHandler)new ReloadRequiredRemoveStepHandler(new RuntimeCapability[]{IO_POOL_RUNTIME_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            defaultDirectBuffers = false;
            defaultBufferSize = 512;
            defaultBuffersPerRegion = 10;
        } else if (maxMemory < 0x8000000L) {
            defaultDirectBuffers = true;
            defaultBufferSize = 1024;
            defaultBuffersPerRegion = 10;
        } else {
            defaultDirectBuffers = true;
            defaultBufferSize = 16384;
            defaultBuffersPerRegion = 20;
        }
        BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffer-size", ModelType.INT, true).setAllowExpression(true)).build();
        BUFFER_PER_SLICE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffers-per-slice", ModelType.INT, true).setAllowExpression(true)).build();
        DIRECT_BUFFERS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("direct-buffers", ModelType.BOOLEAN, true).setAllowExpression(true)).build();
        ATTRIBUTES = Arrays.asList(BUFFER_SIZE, BUFFER_PER_SLICE, DIRECT_BUFFERS);
        INSTANCE = new BufferPoolResourceDefinition();
    }

    private static class BufferPoolAdd
    extends AbstractAddStepHandler {
        private BufferPoolAdd() {
            super(IO_POOL_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String name = address.getLastElement().getValue();
            ModelNode bufferSizeModel = BUFFER_SIZE.resolveModelAttribute(context, model);
            ModelNode bufferPerSliceModel = BUFFER_PER_SLICE.resolveModelAttribute(context, model);
            ModelNode directModel = DIRECT_BUFFERS.resolveModelAttribute(context, model);
            int bufferSize = bufferSizeModel.isDefined() ? bufferSizeModel.asInt() : defaultBufferSize;
            int bufferPerSlice = bufferPerSliceModel.isDefined() ? bufferPerSliceModel.asInt() : defaultBuffersPerRegion;
            boolean direct = directModel.isDefined() ? directModel.asBoolean() : defaultDirectBuffers;
            BufferPoolService service = new BufferPoolService(bufferSize, bufferPerSlice, direct);
            context.getServiceTarget().addService(IOServices.BUFFER_POOL.append(new String[]{name}), (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

