/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.ServletRequestContext;

class ServletRequestContextThreadSetupAction
implements ThreadSetupAction {
    static final ServletRequestContextThreadSetupAction INSTANCE = new ServletRequestContextThreadSetupAction();
    private static final ThreadSetupAction.Handle HANDLE = new ThreadSetupAction.Handle(){

        @Override
        public void tearDown() {
            SecurityActions.clearCurrentServletAttachments();
        }
    };

    private ServletRequestContextThreadSetupAction() {
    }

    @Override
    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        if (exchange == null) {
            return null;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        SecurityActions.setCurrentRequestContext(servletRequestContext);
        return HANDLE;
    }
}

