/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

final class StandaloneServerIndirection
implements StandaloneServer {
    private final Object standaloneServer;
    private final Method methodStart;
    private final Method methodStop;
    private final Method methodGetModelControllerClient;

    StandaloneServerIndirection(Class<?> standaloneServerClass, Object standaloneServerImpl) {
        this.standaloneServer = standaloneServerImpl;
        try {
            this.methodStart = standaloneServerClass.getMethod("start", new Class[0]);
            this.methodStop = standaloneServerClass.getMethod("stop", new Class[0]);
            this.methodGetModelControllerClient = standaloneServerClass.getMethod("getModelControllerClient", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, nsme.getMessage(), standaloneServerClass.getName());
        }
    }

    @Override
    public void start() {
        this.invokeOnServer(this.methodStart, new Object[0]);
    }

    @Override
    public void stop() {
        this.invokeOnServer(this.methodStop, new Object[0]);
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return (ModelControllerClient)this.invokeOnServer(this.methodGetModelControllerClient, new Object[0]);
    }

    private Object invokeOnServer(Method method, Object ... args) {
        try {
            return method.invoke(this.standaloneServer, args);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)ex).getCause();
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotInvokeStandaloneServer(cause, method.getName());
        }
    }
}

