/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ConnectionPoolManager;
import io.undertow.server.handlers.proxy.ProxyConnectionPool;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeHealthChecker;
import io.undertow.server.handlers.proxy.mod_cluster.NodeLbStatus;
import io.undertow.server.handlers.proxy.mod_cluster.NodePingUtil;
import io.undertow.server.handlers.proxy.mod_cluster.NodeStats;
import io.undertow.server.handlers.proxy.mod_cluster.NodeStatus;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioIoThread;

class Node {
    private final int id;
    private final String jvmRoute;
    private final ConnectionPoolManager connectionPoolManager;
    private final NodeConfig nodeConfig;
    private final Balancer balancerConfig;
    private final ProxyConnectionPool connectionPool;
    private final NodeStats stats = new NodeStats();
    private final NodeLbStatus lbStatus = new NodeLbStatus();
    private final ModClusterContainer container;
    private final List<VHostMapping> vHosts = new CopyOnWriteArrayList<VHostMapping>();
    private final List<Context> contexts = new CopyOnWriteArrayList<Context>();
    private final XnioIoThread ioThread;
    private final Pool<ByteBuffer> bufferPool;
    private volatile int state = Integer.MIN_VALUE;
    private static final int ERROR = Integer.MIN_VALUE;
    private static final int REMOVED = 0x40000000;
    private static final int HOT_STANDBY = 0x20000000;
    private static final int ACTIVE_PING = 0x10000000;
    private static final int ERROR_MASK = 1023;
    private static final AtomicInteger idGen = new AtomicInteger();
    private static final AtomicIntegerFieldUpdater<Node> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(Node.class, "state");
    static final AtomicInteger vHostIdGen = new AtomicInteger();

    protected Node(NodeConfig nodeConfig, Balancer balancerConfig, XnioIoThread ioThread, Pool<ByteBuffer> bufferPool, ModClusterContainer container) {
        this.id = idGen.incrementAndGet();
        this.jvmRoute = nodeConfig.getJvmRoute();
        this.nodeConfig = nodeConfig;
        this.ioThread = ioThread;
        this.bufferPool = bufferPool;
        this.balancerConfig = balancerConfig;
        this.container = container;
        this.connectionPoolManager = new NodeConnectionPoolManager();
        this.connectionPool = new ProxyConnectionPool(this.connectionPoolManager, nodeConfig.getConnectionURI(), container.getXnioSsl(), container.getClient(), OptionMap.EMPTY);
    }

    public int getId() {
        return this.id;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public Balancer getBalancer() {
        return this.balancerConfig;
    }

    public NodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public NodeStats getStats() {
        return this.stats;
    }

    public ProxyConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    XnioIoThread getIoThread() {
        return this.ioThread;
    }

    public NodeStatus getStatus() {
        int status = this.state;
        if (Bits.anyAreSet((int)status, (int)Integer.MIN_VALUE)) {
            return NodeStatus.NODE_DOWN;
        }
        if (Bits.anyAreSet((int)status, (int)0x20000000)) {
            return NodeStatus.NODE_HOT_STANDBY;
        }
        return NodeStatus.NODE_UP;
    }

    public int getElected() {
        return this.lbStatus.getElected();
    }

    int getElectedDiff() {
        return this.lbStatus.getElectedDiff();
    }

    public int getLoad() {
        int status = this.state;
        if (Bits.anyAreSet((int)status, (int)Integer.MIN_VALUE)) {
            return -1;
        }
        if (Bits.anyAreSet((int)status, (int)0x20000000)) {
            return 0;
        }
        return this.lbStatus.getLbFactor();
    }

    public int getLoadStatus() {
        return this.lbStatus.getLbStatus();
    }

    void elected() {
        this.lbStatus.elected();
    }

    List<VHostMapping> getVHosts() {
        return Collections.unmodifiableList(this.vHosts);
    }

    Collection<Context> getContexts() {
        return Collections.unmodifiableCollection(this.contexts);
    }

    void resetLbStatus() {
        if (Bits.allAreClear((int)this.state, (int)Integer.MIN_VALUE) && this.lbStatus.update()) {
            return;
        }
    }

    protected void checkHealth(long threshold, NodeHealthChecker healthChecker) {
        int state = this.state;
        if (Bits.anyAreSet((int)state, (int)0x50000000)) {
            return;
        }
        this.healthCheckPing(threshold, healthChecker);
    }

    void healthCheckPing(final long threshold, NodeHealthChecker healthChecker) {
        int newState;
        int oldState;
        do {
            if (((oldState = this.state) & 0x10000000) == 0) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | 0x10000000));
        NodePingUtil.internalPingNode(this, new NodePingUtil.PingCallback(){

            @Override
            public void completed() {
                Node.this.clearActivePing();
            }

            @Override
            public void failed() {
                if ((long)Node.this.healthCheckFailed() == threshold) {
                    Node.this.ioThread.getWorker().execute(new Runnable(){

                        @Override
                        public void run() {
                            Node.this.container.removeNode(Node.this, true);
                            Node.this.clearActivePing();
                        }
                    });
                } else {
                    Node.this.clearActivePing();
                }
            }
        }, healthChecker, this.ioThread, this.bufferPool, this.container.getClient(), this.container.getXnioSsl(), OptionMap.EMPTY);
    }

    void ping(HttpServerExchange exchange, NodePingUtil.PingCallback callback) {
        NodePingUtil.pingNode(this, exchange, callback);
    }

    Context registerContext(String path, List<String> virtualHosts) {
        VHostMapping host = null;
        for (VHostMapping vhost : this.vHosts) {
            if (!virtualHosts.equals(vhost.getAliases())) continue;
            host = vhost;
            break;
        }
        if (host == null) {
            host = new VHostMapping(this, virtualHosts);
            this.vHosts.add(host);
        }
        Context context = new Context(path, host, this);
        this.contexts.add(context);
        return context;
    }

    Context getContext(String path, List<String> aliases) {
        VHostMapping host = null;
        for (VHostMapping vhost : this.vHosts) {
            if (!aliases.equals(vhost.getAliases())) continue;
            host = vhost;
            break;
        }
        if (host == null) {
            return null;
        }
        for (Context context : this.contexts) {
            if (!context.getPath().equals(path) || context.getVhost() != host) continue;
            return context;
        }
        return null;
    }

    boolean disableContext(String path, List<String> aliases) {
        Context context = this.getContext(path, aliases);
        if (context != null) {
            context.disable();
            return true;
        }
        return false;
    }

    int stopContext(String path, List<String> aliases) {
        Context context = this.getContext(path, aliases);
        if (context != null) {
            context.stop();
            return context.getActiveRequests();
        }
        return -1;
    }

    Context removeContext(String path, List<String> aliases) {
        Context context = this.getContext(path, aliases);
        if (context != null) {
            context.stop();
            this.contexts.remove(context);
            return context;
        }
        return null;
    }

    protected void updateLoad(int i) {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState & 0x5FFFFC00)) {
        }
        this.lbStatus.updateLoad(i);
    }

    protected void hotStandby() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState | 0x20000000)) {
        }
        this.lbStatus.updateLoad(0);
    }

    protected void markRemoved() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState | 0x40000000)) {
        }
        this.connectionPool.close();
    }

    protected void markInError() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState | Integer.MIN_VALUE)) {
        }
        UndertowLogger.ROOT_LOGGER.nodeIsInError(this.jvmRoute);
    }

    private void clearActivePing() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState & 0xEFFFFFFF)) {
        }
    }

    private int healthCheckFailed() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                newState = oldState | Integer.MIN_VALUE;
                UndertowLogger.ROOT_LOGGER.nodeIsInError(this.jvmRoute);
                continue;
            }
            if ((oldState & 0x3FF) == 1023) {
                return 1023;
            }
            newState = oldState + 1;
        } while (!stateUpdater.compareAndSet(this, oldState, newState));
        return newState & 0x3FF;
    }

    protected void resetState() {
        this.state = Integer.MIN_VALUE;
        this.lbStatus.updateLoad(0);
    }

    protected boolean isInErrorState() {
        return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    boolean isHotStandby() {
        return Bits.anyAreSet((int)this.state, (int)0x20000000);
    }

    protected boolean checkAvailable(boolean existingSession) {
        if (Bits.allAreClear((int)this.state, (int)-1073741824)) {
            ProxyConnectionPool.AvailabilityType availability = this.connectionPool.available();
            if (availability == ProxyConnectionPool.AvailabilityType.AVAILABLE) {
                return true;
            }
            if (availability == ProxyConnectionPool.AvailabilityType.FULL) {
                if (existingSession) {
                    return true;
                }
                if (!existingSession && this.nodeConfig.isQueueNewRequests()) {
                    return true;
                }
            }
        }
        return false;
    }

    static class VHostMapping {
        private final int id = vHostIdGen.incrementAndGet();
        private final List<String> aliases;
        private final Node node;

        VHostMapping(Node node, List<String> aliases) {
            this.aliases = aliases;
            this.node = node;
        }

        public int getId() {
            return this.id;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        Node getNode() {
            return this.node;
        }
    }

    private class NodeConnectionPoolManager
    implements ConnectionPoolManager {
        private NodeConnectionPoolManager() {
        }

        @Override
        public boolean isAvailable() {
            return Bits.allAreClear((int)Node.this.state, (int)-1073741824);
        }

        @Override
        public boolean handleError() {
            Node.this.markInError();
            return false;
        }

        @Override
        public boolean clearError() {
            return this.isAvailable();
        }

        @Override
        public int getMaxConnections() {
            return Node.this.nodeConfig.getMaxConnections();
        }

        @Override
        public int getMaxCachedConnections() {
            return Node.this.nodeConfig.getCacheConnections();
        }

        @Override
        public int getSMaxConnections() {
            return Node.this.nodeConfig.getSmax();
        }

        @Override
        public long getTtl() {
            return Node.this.nodeConfig.getTtl();
        }

        @Override
        public int getMaxQueueSize() {
            return Node.this.nodeConfig.getRequestQueueSize();
        }

        @Override
        public int getProblemServerRetry() {
            return -1;
        }
    }
}

